/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.fixture;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.jackrabbit.oak.fixture.NodeStoreFixture;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class SegmentAwsFixture
extends NodeStoreFixture {
    private static final String AWS_BUCKET_NAME = System.getProperty("oak.segment.aws.bucketName", "oak");
    private static final String AWS_ROOT_PATH = System.getProperty("oak.segment.aws.rootPath", "/oak");
    private static final String AWS_JOURNAL_TABLE_NAME = System.getProperty("oak.segment.aws.tableName", "journaltable");
    private static final String AWS_LOCK_TABLE_NAME = System.getProperty("oak.segment.aws.lockTableName", "locktable");
    private Map<NodeStore, FileStore> fileStoreMap = new HashMap<NodeStore, FileStore>();
    private Map<NodeStore, String> bucketNameMap = new HashMap<NodeStore, String>();
    private S3MockRule s3Mock;
    private AmazonS3 s3;
    private AmazonDynamoDB ddb;

    public NodeStore createNodeStore() {
        AwsPersistence persistence;
        String bucketName;
        if (this.s3Mock == null) {
            this.s3Mock = new S3MockRule();
            try {
                this.s3 = this.s3Mock.createClient();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        }
        try {
            while (this.s3.doesBucketExistV2(bucketName = AWS_BUCKET_NAME + "-" + UUID.randomUUID().toString())) {
            }
            this.s3.createBucket(bucketName);
            AwsContext awsContext = AwsContext.create((AmazonS3)this.s3, (String)bucketName, (String)AWS_ROOT_PATH, (AmazonDynamoDB)this.ddb, (String)AWS_JOURNAL_TABLE_NAME, (String)AWS_LOCK_TABLE_NAME);
            persistence = new AwsPersistence(awsContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            FileStore fileStore = FileStoreBuilder.fileStoreBuilder((File)Files.createTempDir()).withCustomPersistence((SegmentNodeStorePersistence)persistence).build();
            SegmentNodeStore nodeStore = SegmentNodeStoreBuilders.builder((FileStore)fileStore).build();
            this.fileStoreMap.put((NodeStore)nodeStore, fileStore);
            this.bucketNameMap.put((NodeStore)nodeStore, bucketName);
            return nodeStore;
        }
        catch (IOException | InvalidFileStoreVersionException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose(NodeStore nodeStore) {
        FileStore fs = this.fileStoreMap.remove(nodeStore);
        if (fs != null) {
            fs.close();
        }
        try {
            String bucketName = this.bucketNameMap.remove(nodeStore);
            if (this.s3.doesBucketExistV2(bucketName)) {
                this.s3.deleteBucket(bucketName);
            }
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.s3Mock != null) {
                this.s3Mock.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "SegmentAws";
    }
}

