/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.aws.AwsArchiveManager;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.AwsSegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.aws.AwsSegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.spi.RepositoryNotReachableException;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AwsReadSegmentTest {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();
    private AwsContext awsContext;

    @Before
    public void setup() throws IOException {
        AmazonS3 s3 = s3Mock.createClient();
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.awsContext = AwsContext.create((AmazonS3)s3, (String)("bucket-" + time), (String)"oak", (AmazonDynamoDB)ddb, (String)("journaltable-" + time), (String)("locktable-" + time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SegmentNotFoundException.class)
    public void testReadNonExistentSegmentRepositoryReachable() throws InvalidFileStoreVersionException, IOException {
        AwsPersistence p = new AwsPersistence(this.awsContext);
        FileStore fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        SegmentId id = new SegmentId((SegmentStore)fs, 0L, 0L);
        try {
            fs.readSegment(id);
        }
        finally {
            fs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryNotReachableException.class)
    public void testReadExistentSegmentRepositoryNotReachable() throws InvalidFileStoreVersionException, IOException {
        ReadFailingAwsPersistence p = new ReadFailingAwsPersistence(this.awsContext);
        FileStore fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        SegmentId id = new SegmentId((SegmentStore)fs, 0L, 0L);
        byte[] buffer = new byte[2];
        try {
            fs.writeSegment(id, buffer, 0, 2);
            fs.readSegment(id);
        }
        finally {
            fs.close();
        }
    }

    static class ReadFailingAwsPersistence
    extends AwsPersistence {
        public ReadFailingAwsPersistence(AwsContext awsContext) {
            super(awsContext);
        }

        public SegmentArchiveManager createArchiveManager(boolean mmap, boolean offHeapAccess, final IOMonitor ioMonitor, final FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) {
            return new AwsArchiveManager(this.awsContext.directory, ioMonitor, fileStoreMonitor){

                public SegmentArchiveReader open(String archiveName) throws IOException {
                    S3Directory archiveDirectory = awsContext.directory.withDirectory(archiveName);
                    return new AwsSegmentArchiveReader(archiveDirectory, archiveName, ioMonitor){

                        public Buffer readSegment(long msb, long lsb) throws IOException {
                            throw new RepositoryNotReachableException((Throwable)new RuntimeException("Cannot access AWS S3"));
                        }
                    };
                }

                public SegmentArchiveWriter create(String archiveName) throws IOException {
                    S3Directory archiveDirectory = awsContext.directory.withDirectory(archiveName);
                    return new AwsSegmentArchiveWriter(archiveDirectory, archiveName, ioMonitor, fileStoreMonitor){

                        public Buffer readSegment(long msb, long lsb) throws IOException {
                            throw new RepositoryNotReachableException((Throwable)new RuntimeException("Cannot access AWS S3"));
                        }
                    };
                }
            };
        }
    }
}

