/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CompositeQueryIndexProvider
implements QueryIndexProvider {
    private final List<QueryIndexProvider> providers;

    private CompositeQueryIndexProvider(List<QueryIndexProvider> providers) {
        this.providers = providers;
    }

    public CompositeQueryIndexProvider(QueryIndexProvider ... providers) {
        this(Arrays.asList(providers));
    }

    @Nonnull
    public static QueryIndexProvider compose(@Nonnull Collection<QueryIndexProvider> providers) {
        if (providers.isEmpty()) {
            return new QueryIndexProvider(){

                public List<QueryIndex> getQueryIndexes(NodeState nodeState) {
                    return ImmutableList.of();
                }
            };
        }
        if (providers.size() == 1) {
            return providers.iterator().next();
        }
        return new CompositeQueryIndexProvider((List<QueryIndexProvider>)ImmutableList.copyOf(providers));
    }

    @Override
    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        ArrayList indexes = Lists.newArrayList();
        for (QueryIndexProvider provider : this.providers) {
            indexes.addAll(provider.getQueryIndexes(nodeState));
        }
        return indexes;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.providers.toString();
    }
}

