/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.xml.BufferedStringValue;
import org.apache.jackrabbit.oak.jcr.xml.TargetImportHandler;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SysViewImportHandler
extends TargetImportHandler {
    private final Stack<ImportState> stack = new Stack();
    private final ArrayList<BufferedStringValue> currentPropValues = new ArrayList();
    private TargetImportHandler.NameInfo currentPropName;
    private int currentPropType = 0;
    private PropInfo.MultipleStatus currentPropMultipleStatus = PropInfo.MultipleStatus.UNKNOWN;
    private BufferedStringValue currentPropValue;

    SysViewImportHandler(Importer importer, SessionContext sessionContext) {
        super(importer, sessionContext);
    }

    private void processNode(ImportState state, boolean start, boolean end) throws SAXException {
        if (!start && !end) {
            return;
        }
        String id = state.uuid;
        NodeInfo node = new NodeInfo(state.nodeName, state.nodeTypeName, state.mixinNames, id);
        try {
            if (start) {
                this.importer.startNode(node, state.props);
                for (PropInfo pi : state.props) {
                    pi.dispose();
                }
            }
            if (end) {
                this.importer.endNode(node);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "node".equals(localName)) {
            String svName = SysViewImportHandler.getAttribute(atts, "http://www.jcp.org/jcr/sv/1.0", "name");
            if (svName == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:node"));
            }
            if (!this.stack.isEmpty()) {
                ImportState current = this.stack.peek();
                if (!current.started) {
                    this.processNode(current, true, false);
                    current.started = true;
                }
            }
            ImportState state = new ImportState();
            try {
                state.nodeName = new TargetImportHandler.NameInfo(this, svName).getRepoQualifiedName();
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + svName, (Throwable)e));
            }
            this.stack.push(state);
        } else if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "property".equals(localName)) {
            this.currentPropValues.clear();
            String svName = SysViewImportHandler.getAttribute(atts, "http://www.jcp.org/jcr/sv/1.0", "name");
            if (svName == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:property"));
            }
            try {
                this.currentPropName = new TargetImportHandler.NameInfo(this, svName);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + svName, (Throwable)e));
            }
            String type = SysViewImportHandler.getAttribute(atts, "http://www.jcp.org/jcr/sv/1.0", "type");
            if (type == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:type attribute of element sv:property"));
            }
            try {
                this.currentPropType = PropertyType.valueFromName((String)type);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("Unknown property type: " + type, (Throwable)e));
            }
            String multiple = SysViewImportHandler.getAttribute(atts, "http://www.jcp.org/jcr/sv/1.0", "multiple");
            this.currentPropMultipleStatus = multiple != null ? PropInfo.MultipleStatus.MULTIPLE : PropInfo.MultipleStatus.UNKNOWN;
        } else if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "value".equals(localName)) {
            boolean base64 = this.currentPropType == 2 || "xs:base64Binary".equals(atts.getValue("xsi:type"));
            this.currentPropValue = new BufferedStringValue(this.sessionContext.getValueFactory(), this.currentNamePathMapper(), base64);
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("Unexpected element in system view xml document: {" + namespaceURI + '}' + localName));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ImportState state = this.stack.peek();
        if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "node".equals(localName)) {
            if (!state.started) {
                this.processNode(state, true, true);
                state.started = true;
            } else {
                this.processNode(state, false, true);
            }
            this.stack.pop();
        } else if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "property".equals(localName)) {
            if (this.isSystemProperty("primaryType")) {
                BufferedStringValue val = this.currentPropValues.get(0);
                String s = null;
                try {
                    s = val.retrieve();
                    state.nodeTypeName = new TargetImportHandler.NameInfo(this, s).getRepoQualifiedName();
                }
                catch (IOException e) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)e));
                }
                catch (RepositoryException e) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)e));
                }
            } else if (this.isSystemProperty("mixinTypes")) {
                if (state.mixinNames == null) {
                    state.mixinNames = new ArrayList<String>(this.currentPropValues.size());
                }
                for (BufferedStringValue val : this.currentPropValues) {
                    String s = null;
                    try {
                        s = val.retrieve();
                        state.mixinNames.add(new TargetImportHandler.NameInfo(this, s).getRepoQualifiedName());
                    }
                    catch (IOException ioe) {
                        throw new SAXException("error while retrieving value", ioe);
                    }
                    catch (RepositoryException e) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)e));
                    }
                }
            } else if (this.isSystemProperty("uuid")) {
                BufferedStringValue val = this.currentPropValues.get(0);
                try {
                    state.uuid = val.retrieve();
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
            } else {
                if (this.currentPropMultipleStatus == PropInfo.MultipleStatus.UNKNOWN && this.currentPropValues.size() != 1) {
                    this.currentPropMultipleStatus = PropInfo.MultipleStatus.MULTIPLE;
                }
                PropInfo prop = new PropInfo(this.currentPropName == null ? null : this.currentPropName.getRepoQualifiedName(), this.currentPropType, this.currentPropValues, this.currentPropMultipleStatus);
                state.props.add(prop);
            }
            this.currentPropValues.clear();
        } else if (namespaceURI.equals("http://www.jcp.org/jcr/sv/1.0") && "value".equals(localName)) {
            this.currentPropValues.add(this.currentPropValue);
            this.currentPropValue = null;
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid element in system view xml document: " + localName));
        }
    }

    private boolean isSystemProperty(@Nonnull String localName) {
        return this.currentPropName != null && this.currentPropName.getNamespaceUri().equals("http://www.jcp.org/jcr/1.0") && this.currentPropName.getLocalName().equals(localName);
    }

    private static String getAttribute(Attributes attributes, String namespaceUri, String localName) {
        return attributes.getValue(namespaceUri, localName);
    }

    static class ImportState {
        String nodeName;
        String nodeTypeName;
        List<String> mixinNames;
        String uuid;
        final List<PropInfo> props = new ArrayList<PropInfo>();
        boolean started;

        ImportState() {
        }
    }
}

