/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.MurmurHash3;

public class HashUtils {
    private HashUtils() {
    }

    public static long hash64(String s) {
        return MurmurHash3.hash128((byte[])s.getBytes(StandardCharsets.UTF_8))[0];
    }

    public static long hash64(long x, long seed) {
        x += seed;
        x = (x ^ x >>> 33) * -49064778989728563L;
        x = (x ^ x >>> 33) * -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    public static long hash64(long x) {
        return HashUtils.hash64(x, 100L);
    }

    public static int reduce(int hash, int n) {
        return (int)(((long)hash & 0xFFFFFFFFL) * ((long)n & 0xFFFFFFFFL) >>> 32);
    }
}

