/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.benchmark;

import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public final class MicroBenchmark {
    private MicroBenchmark() {
    }

    public static void run(Benchmark benchmark) throws Exception {
        benchmark.setup();
        try {
            MicroBenchmark.runTest(benchmark);
            benchmark.result(MicroBenchmark.runTest(benchmark));
        }
        finally {
            benchmark.tearDown();
        }
    }

    private static DescriptiveStatistics runTest(Benchmark benchmark) throws Exception {
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        long runtimeEnd = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        while (System.currentTimeMillis() < runtimeEnd) {
            statistics.addValue(MicroBenchmark.execute(benchmark));
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double execute(Benchmark benchmark) throws Exception {
        benchmark.beforeRun();
        try {
            long start = System.nanoTime();
            benchmark.run();
            double d = System.nanoTime() - start;
            return d;
        }
        finally {
            benchmark.afterRun();
        }
    }

    public static abstract class Benchmark {
        public void setup() throws Exception {
        }

        public void beforeRun() throws Exception {
        }

        public abstract void run() throws Exception;

        public void afterRun() throws Exception {
        }

        public void result(DescriptiveStatistics statistics) {
            System.out.println(this);
            if (statistics.getN() > 0L) {
                System.out.format("%6s  %6s  %6s  %6s  %6s  %6s  %6s  %6s%n", "min", "10%", "50%", "90%", "max", "mean", "stdev", "N");
                System.out.format("%6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6d%n", statistics.getMin() / 1000000.0, statistics.getPercentile(10.0) / 1000000.0, statistics.getPercentile(50.0) / 1000000.0, statistics.getPercentile(90.0) / 1000000.0, statistics.getMax() / 1000000.0, statistics.getMean() / 1000000.0, statistics.getStandardDeviation() / 1000000.0, statistics.getN());
            } else {
                System.out.println("No results");
            }
        }

        public void tearDown() throws Exception {
        }
    }
}

