/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.mk;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.oak.commons.IOUtils;

public class MicroKernelInputStream
extends InputStream {
    private final MicroKernel mk;
    private final String id;
    private long pos;
    private long length = -1L;
    private byte[] oneByteBuff;

    public MicroKernelInputStream(MicroKernel mk, String id) {
        this.mk = mk;
        this.id = id;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            return 0L;
        }
        if (this.length == -1L) {
            this.length = this.mk.getLength(this.id);
        }
        n = Math.min(n, this.length - this.pos);
        this.pos += n;
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int l = this.mk.read(this.id, this.pos, b, off, len);
        if (l <= 0) {
            return -1;
        }
        this.pos += (long)l;
        return l;
    }

    @Override
    public int read() throws IOException {
        int len;
        if (this.oneByteBuff == null) {
            this.oneByteBuff = new byte[1];
        }
        if ((len = this.read(this.oneByteBuff, 0, 1)) < 0) {
            return len;
        }
        return this.oneByteBuff[0] & 0xFF;
    }

    public static byte[] readFully(MicroKernel mk, String id) throws IOException {
        int len = (int)mk.getLength(id);
        byte[] buff = new byte[len];
        MicroKernelInputStream in = new MicroKernelInputStream(mk, id);
        IOUtils.readFully(in, buff, 0, len);
        return buff;
    }
}

