/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class PathUtils {
    private static final Pattern SNS_PATTERN = Pattern.compile("(.+)\\[[1-9][0-9]*\\]$");

    private PathUtils() {
    }

    public static boolean denotesRoot(String path) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        return PathUtils.denotesRootPath(path);
    }

    private static boolean denotesRootPath(String path) {
        return "/".equals(path);
    }

    public static boolean denotesCurrent(String element) {
        return ".".equals(element);
    }

    public static boolean denotesParent(String element) {
        return "..".equals(element);
    }

    public static boolean isAbsolute(String path) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        return PathUtils.isAbsolutePath(path);
    }

    private static boolean isAbsolutePath(String path) {
        return !path.isEmpty() && path.charAt(0) == '/';
    }

    @Nonnull
    public static String getParentPath(String path) {
        return PathUtils.getAncestorPath(path, 1);
    }

    @Nonnull
    public static String getAncestorPath(String path, int nth) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        if (path.isEmpty() || PathUtils.denotesRootPath(path) || nth <= 0) {
            return path;
        }
        int end = path.length() - 1;
        int pos = -1;
        while (nth-- > 0) {
            pos = path.lastIndexOf(47, end);
            if (pos > 0) {
                end = pos - 1;
                continue;
            }
            if (pos == 0) {
                return "/";
            }
            return "";
        }
        return path.substring(0, pos);
    }

    @Nonnull
    public static String getName(String path) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        if (path.isEmpty() || PathUtils.denotesRootPath(path)) {
            return "";
        }
        int end = path.length() - 1;
        int pos = path.lastIndexOf(47, end);
        if (pos != -1) {
            return path.substring(pos + 1, end + 1);
        }
        return path;
    }

    @Nonnull
    public static String dropIndexFromName(@Nonnull String name) {
        Matcher matcher = SNS_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return name;
    }

    public static int getDepth(String path) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        if (path.isEmpty()) {
            return 0;
        }
        int count = 1;
        int i = 0;
        if (PathUtils.isAbsolutePath(path)) {
            if (PathUtils.denotesRootPath(path)) {
                return 0;
            }
            ++i;
        }
        while ((i = path.indexOf(47, i) + 1) != 0) {
            ++count;
        }
        return count;
    }

    @Nonnull
    public static Iterable<String> elements(final String path) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int pos;
                    String next;
                    {
                        this.pos = PathUtils.isAbsolute(path) ? 1 : 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            if (this.pos >= path.length()) {
                                return false;
                            }
                            int i = path.indexOf(47, this.pos);
                            if (i < 0) {
                                this.next = path.substring(this.pos);
                                this.pos = path.length();
                            } else {
                                this.next = path.substring(this.pos, i);
                                this.pos = i + 1;
                            }
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        if (this.hasNext()) {
                            String next = this.next;
                            this.next = null;
                            return next;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Nonnull
    public static String concat(String parentPath, String ... relativePaths) {
        assert (PathUtils.isValid(parentPath)) : "Invalid parent path [" + parentPath + "]";
        int parentLen = parentPath.length();
        int size = relativePaths.length;
        StringBuilder buff = new StringBuilder(parentLen + size * 5);
        buff.append(parentPath);
        boolean needSlash = parentLen > 0 && !PathUtils.denotesRootPath(parentPath);
        for (String s : relativePaths) {
            assert (PathUtils.isValid(s));
            if (PathUtils.isAbsolutePath(s)) {
                throw new IllegalArgumentException("Cannot append absolute path " + s);
            }
            if (s.isEmpty()) continue;
            if (needSlash) {
                buff.append('/');
            }
            buff.append(s);
            needSlash = true;
        }
        return buff.toString();
    }

    @Nonnull
    public static String concat(String parentPath, String subPath) {
        assert (PathUtils.isValid(parentPath)) : "Invalid parent path [" + parentPath + "]";
        assert (PathUtils.isValid(subPath)) : "Invalid sub path [" + subPath + "]";
        if (parentPath.isEmpty()) {
            return subPath;
        }
        if (subPath.isEmpty()) {
            return parentPath;
        }
        if (PathUtils.isAbsolutePath(subPath)) {
            throw new IllegalArgumentException("Cannot append absolute path " + subPath);
        }
        StringBuilder buff = new StringBuilder(parentPath);
        if (!PathUtils.denotesRootPath(parentPath)) {
            buff.append('/');
        }
        buff.append(subPath);
        return buff.toString();
    }

    @CheckForNull
    public static String concatRelativePaths(String ... relativePaths) {
        StringBuilder result = new StringBuilder();
        for (String path : relativePaths) {
            int i0;
            if (path == null || path.isEmpty()) continue;
            int i1 = path.length();
            for (i0 = 0; i0 < i1 && path.charAt(i0) == '/'; ++i0) {
            }
            while (i1 > i0 && path.charAt(i1 - 1) == '/') {
                --i1;
            }
            if (i1 <= i0) continue;
            if (result.length() > 0) {
                result.append('/');
            }
            result.append(path.substring(i0, i1));
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static boolean isAncestor(String ancestor, String path) {
        assert (PathUtils.isValid(ancestor)) : "Invalid parent path [" + ancestor + "]";
        assert (PathUtils.isValid(path)) : "Invalid path [" + ancestor + "]";
        if (ancestor.isEmpty() || path.isEmpty()) {
            return false;
        }
        if (PathUtils.denotesRoot(ancestor)) {
            if (PathUtils.denotesRoot(path)) {
                return false;
            }
        } else {
            ancestor = ancestor + "/";
        }
        return path.startsWith(ancestor);
    }

    @Nonnull
    public static String relativize(String parentPath, String path) {
        String prefix;
        assert (PathUtils.isValid(parentPath)) : "Invalid parent path [" + parentPath + "]";
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        if (parentPath.equals(path)) {
            return "";
        }
        String string = prefix = PathUtils.denotesRootPath(parentPath) ? parentPath : parentPath + '/';
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        throw new IllegalArgumentException("Cannot relativize " + path + " wrt. " + parentPath);
    }

    public static int getNextSlash(String path, int index) {
        assert (PathUtils.isValid(path)) : "Invalid path [" + path + "]";
        return path.indexOf(47, index);
    }

    public static void validate(String path) {
        if (path.isEmpty() || PathUtils.denotesRootPath(path)) {
            return;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path may not end with '/': " + path);
        }
        char last = '\u0000';
        int len = path.length();
        for (int index = 0; index < len; ++index) {
            char c = path.charAt(index);
            if (c == '/' && last == '/') {
                throw new IllegalArgumentException("Path may not contains '//': " + path);
            }
            last = c;
        }
    }

    public static boolean isValid(String path) {
        if (path.isEmpty() || PathUtils.denotesRootPath(path)) {
            return true;
        }
        if (path.charAt(path.length() - 1) == '/') {
            return false;
        }
        char last = '\u0000';
        int len = path.length();
        for (int index = 0; index < len; ++index) {
            char c = path.charAt(index);
            if (c == '/' && last == '/') {
                return false;
            }
            last = c;
        }
        return true;
    }

    public static void unifyInExcludes(Set<String> includePaths, Set<String> excludedPaths) {
        HashSet retain = Sets.newHashSet();
        HashSet includesRemoved = Sets.newHashSet();
        for (String include : includePaths) {
            for (String exclude : excludedPaths) {
                if (exclude.equals(include) || PathUtils.isAncestor(exclude, include)) {
                    includesRemoved.add(include);
                    continue;
                }
                if (!PathUtils.isAncestor(include, exclude)) continue;
                retain.add(exclude);
            }
            for (String include2 : includePaths) {
                if (!PathUtils.isAncestor(include, include2)) continue;
                includesRemoved.add(include2);
            }
        }
        includePaths.removeAll(includesRemoved);
        excludedPaths.retainAll(retain);
    }
}

