/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.io.IOException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.LookupLdapConnectionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableUnboundConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private static final Logger log = LoggerFactory.getLogger(PoolableUnboundConnectionFactory.class);
    private LdapConnectionConfig config;
    private LdapConnectionValidator validator = new LookupLdapConnectionValidator();

    public PoolableUnboundConnectionFactory(LdapConnectionConfig config) {
        this.config = config;
    }

    public LdapConnectionValidator getValidator() {
        return this.validator;
    }

    public void setValidator(LdapConnectionValidator validator) {
        this.validator = validator;
    }

    public void activateObject(LdapConnection connection) {
        log.debug("activate connection: {}", (Object)connection);
    }

    public void destroyObject(LdapConnection connection) throws IOException {
        log.debug("destroy connection: {}", (Object)connection);
        connection.close();
    }

    public LdapConnection makeObject() throws LdapException {
        TlsGuardingConnection connection = this.config.isUseTls() ? new TlsGuardingConnection(this.config) : new LdapNetworkConnection(this.config);
        connection.connect();
        log.debug("creating new connection: {}", (Object)connection);
        return connection;
    }

    public void passivateObject(LdapConnection connection) {
        log.debug("passivate connection: {}", (Object)connection);
    }

    public boolean validateObject(LdapConnection connection) {
        boolean valid = this.validator == null || this.validator.validate(connection);
        log.debug("validating connection {}: {}", (Object)connection, (Object)valid);
        return valid;
    }

    private static final class TlsGuardingConnection
    extends LdapNetworkConnection {
        private boolean tlsStarted;

        private TlsGuardingConnection(LdapConnectionConfig config) {
            super(config);
        }

        public void startTls() throws LdapException {
            if (this.tlsStarted) {
                return;
            }
            super.startTls();
            this.tlsStarted = true;
        }
    }
}

