/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProperties;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.jetbrains.annotations.NotNull;

public abstract class LdapIdentity
implements ExternalIdentity {
    protected final LdapIdentityProvider provider;
    protected final ExternalIdentityRef ref;
    protected final String id;
    protected final String path;
    protected final Entry entry;
    private Map<String, ExternalIdentityRef> groups;
    private final LdapIdentityProperties properties = new LdapIdentityProperties();

    protected LdapIdentity(LdapIdentityProvider provider, ExternalIdentityRef ref, String id, String path, Entry entry) {
        this.provider = provider;
        this.ref = ref;
        this.id = id;
        this.path = path;
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    @NotNull
    public ExternalIdentityRef getExternalId() {
        return this.ref;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getPrincipalName() {
        return this.ref.getId();
    }

    public String getIntermediatePath() {
        return this.path;
    }

    @NotNull
    public Iterable<ExternalIdentityRef> getDeclaredGroups() throws ExternalIdentityException {
        if (this.groups == null) {
            this.groups = this.provider.getDeclaredGroupRefs(this.ref, this.entry.getDn().getName());
        }
        return this.groups.values();
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "LdapIdentity{ref=" + this.ref + ", id='" + this.id + '\'' + '}';
    }
}

