/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.ErrorSyncResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResultMessages {
    private static final Logger log = LoggerFactory.getLogger(ResultMessages.class);
    private final List<String> messages = new ArrayList<String>();

    ResultMessages() {
    }

    String[] getMessages() {
        return this.messages.toArray(new String[0]);
    }

    void append(@NotNull List<SyncResult> results) {
        for (SyncResult result : results) {
            this.append(result);
        }
    }

    void append(@NotNull List<SyncResult> results, @NotNull Exception e) {
        block3: for (SyncResult result : results) {
            if (result instanceof ErrorSyncResult) {
                this.append(result.getIdentity(), ((ErrorSyncResult)result).getException());
                continue;
            }
            SyncResult.Status st = result.getStatus();
            switch (st) {
                case ADD: 
                case DELETE: 
                case UPDATE: 
                case ENABLE: 
                case DISABLE: {
                    this.append(result.getIdentity(), e);
                    continue block3;
                }
            }
            this.append(result);
        }
    }

    private void append(@NotNull SyncResult r) {
        if (r instanceof ErrorSyncResult) {
            this.append(r.getIdentity(), ((ErrorSyncResult)r).getException());
        } else {
            this.append(r.getIdentity(), ResultMessages.getOperationFromStatus(r.getStatus()), null);
        }
    }

    private void append(@Nullable SyncedIdentity syncedIdentity, @NotNull Exception e) {
        this.append(syncedIdentity, "ERR", e.toString());
    }

    private void append(@Nullable SyncedIdentity syncedIdentity, @NotNull String op, @Nullable String msg) {
        String eid;
        String uid = JsonUtil.getJsonString((String)(syncedIdentity == null ? null : syncedIdentity.getId()));
        ExternalIdentityRef externalIdentityRef = syncedIdentity == null ? null : syncedIdentity.getExternalIdRef();
        String string = eid = externalIdentityRef == null ? "\"\"" : JsonUtil.getJsonString((String)externalIdentityRef.getString());
        if (msg == null) {
            this.messages.add(String.format("{op:\"%s\",uid:%s,eid:%s}", op, uid, eid));
        } else {
            this.messages.add(String.format("{op:\"%s\",uid:%s,eid:%s,msg:%s}", op, uid, eid, JsonUtil.getJsonString((String)msg)));
        }
    }

    private static String getOperationFromStatus(@NotNull SyncResult.Status syncStatus) {
        String op;
        switch (syncStatus) {
            case ADD: {
                op = "add";
                break;
            }
            case UPDATE: {
                op = "upd";
                break;
            }
            case DELETE: {
                op = "del";
                break;
            }
            case ENABLE: {
                op = "ena";
                break;
            }
            case DISABLE: {
                op = "dis";
                break;
            }
            case NO_SUCH_AUTHORIZABLE: {
                op = "nsa";
                break;
            }
            case NO_SUCH_IDENTITY: {
                op = "nsi";
                break;
            }
            case MISSING: {
                op = "mis";
                break;
            }
            case FOREIGN: {
                op = "for";
                break;
            }
            default: {
                op = "nop";
            }
        }
        return op;
    }
}

