/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;

public class ReportMethod
extends DavMethodBase {
    private final boolean isDeep;

    public ReportMethod(String uri, ReportInfo reportInfo) throws IOException {
        super(uri);
        DepthHeader dh = new DepthHeader(reportInfo.getDepth());
        this.isDeep = reportInfo.getDepth() > 0;
        this.setRequestHeader(dh);
        this.setRequestBody(reportInfo);
    }

    @Override
    public String getName() {
        return "REPORT";
    }

    @Override
    protected boolean isSuccess(int statusCode) {
        if (this.isDeep) {
            return statusCode == 207;
        }
        return statusCode == 200 || statusCode == 207;
    }
}

