/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeType;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeTypeManager;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeImpl
extends AbstractNodeType
implements NodeTypeDefinition {
    private static Logger log = LoggerFactory.getLogger(NodeTypeImpl.class);
    private final EffectiveNodeType ent;
    private final NodeTypeManagerImpl ntMgr;
    private final ManagerProvider mgrProvider;

    NodeTypeImpl(EffectiveNodeType ent, QNodeTypeDefinition ntd, NodeTypeManagerImpl ntMgr, ManagerProvider mgrProvider) {
        super(ntd, (AbstractNodeTypeManager)ntMgr, mgrProvider.getNamePathResolver());
        this.ent = ent;
        this.ntMgr = ntMgr;
        this.mgrProvider = mgrProvider;
    }

    private NamePathResolver resolver() {
        return this.mgrProvider.getNamePathResolver();
    }

    private ItemDefinitionProvider definitionProvider() {
        return this.mgrProvider.getItemDefinitionProvider();
    }

    private QPropertyDefinition getApplicablePropDef(Name propertyName, int type, boolean multiValued) throws RepositoryException {
        return this.definitionProvider().getQPropertyDefinition(this.ntd.getName(), propertyName, type, multiValued);
    }

    public boolean isNodeType(Name nodeTypeName) {
        return this.ent.includesNodeType(nodeTypeName);
    }

    private static void checkSetPropertyValueConstraints(QPropertyDefinition def, QValue[] values) throws ConstraintViolationException, RepositoryException {
        ValueConstraint.checkValueConstraints((QPropertyDefinition)def, (QValue[])values);
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public NodeType[] getSupertypes() {
        Name[] ntNames = this.ent.getInheritedNodeTypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        QNodeDefinition[] cnda = this.ent.getAllQNodeDefinitions();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ent.getAllQPropertyDefinitions();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
        }
        return propDefs;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            QPropertyDefinition def;
            Name name = this.resolver().getQName(propertyName);
            try {
                def = this.getApplicablePropDef(name, value.getType(), false);
            }
            catch (ConstraintViolationException cve) {
                def = this.getApplicablePropDef(name, 0, false);
            }
            if (def.isProtected()) {
                return false;
            }
            if (def.isMultiple()) {
                return false;
            }
            Value v = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? ValueHelper.convert((Value)value, (int)def.getRequiredType(), (ValueFactory)this.mgrProvider.getJcrValueFactory()) : value;
            QValue qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.resolver(), (QValueFactory)this.mgrProvider.getQValueFactory());
            NodeTypeImpl.checkSetPropertyValueConstraints(def, new QValue[]{qValue});
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            QPropertyDefinition def;
            Name name = this.resolver().getQName(propertyName);
            int type = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (type == 0) {
                    type = values[i].getType();
                    continue;
                }
                if (type == values[i].getType()) continue;
                return false;
            }
            try {
                def = this.getApplicablePropDef(name, type, true);
            }
            catch (ConstraintViolationException cve) {
                def = this.getApplicablePropDef(name, 0, true);
            }
            if (def.isProtected()) {
                return false;
            }
            if (!def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != type ? def.getRequiredType() : type;
            ArrayList<QValue> list = new ArrayList<QValue>();
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                Value v = ValueHelper.convert((Value)values[i], (int)targetType, (ValueFactory)this.mgrProvider.getJcrValueFactory());
                QValue qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.resolver(), (QValueFactory)this.mgrProvider.getQValueFactory());
                list.add(qValue);
            }
            QValue[] internalValues = list.toArray(new QValue[list.size()]);
            NodeTypeImpl.checkSetPropertyValueConstraints(def, internalValues);
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver().getQName(childNodeName), this.definitionProvider());
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            Name ntName = this.resolver().getQName(nodeTypeName);
            QNodeTypeDefinition def = this.ntMgr.getNodeTypeDefinition(ntName);
            this.ent.checkAddNodeConstraints(this.resolver().getQName(childNodeName), def, this.definitionProvider());
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        try {
            this.ent.checkRemoveItemConstraints(this.resolver().getQName(itemName));
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveNode(String nodeName) {
        Name name;
        try {
            name = this.resolver().getQName(nodeName);
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine if there are any remove constraints for a node with name " + nodeName);
            return false;
        }
        return !this.ent.hasRemoveNodeConstraint(name);
    }

    public boolean canRemoveProperty(String propertyName) {
        Name name;
        try {
            name = this.resolver().getQName(propertyName);
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine if there are any remove constraints for a property with name " + propertyName);
            return false;
        }
        return !this.ent.hasRemovePropertyConstraint(name);
    }
}

