/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractValidateMojo;
import org.apache.jackrabbit.filevault.maven.packaging.MavenBasedPackageDependency;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageInfo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.RepositorySystem;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    private final RepositoryRequest repositoryRequest;
    private final RepositorySystem repositorySystem;
    private final ResolutionErrorHandler resolutionErrorHandler;
    private final Map<Dependency, Artifact> mapPackageDependencyToMavenArtifact;
    private final Collection<PackageInfo> knownPackageInfos;

    public DependencyResolver(RepositoryRequest repositoryRequest, RepositorySystem repositorySystem, ResolutionErrorHandler resolutionErrorHandler, Map<Dependency, Artifact> mapPackageDependencyToMavenArtifact, Collection<PackageInfo> knownPackageInfos) {
        this.repositoryRequest = repositoryRequest;
        this.repositorySystem = repositorySystem;
        this.resolutionErrorHandler = resolutionErrorHandler;
        this.mapPackageDependencyToMavenArtifact = mapPackageDependencyToMavenArtifact;
        this.knownPackageInfos = knownPackageInfos;
    }

    public List<PackageInfo> resolve(Dependency[] packageDependencies, Map<PackageId, URI> packageLocations, Log log) throws IOException {
        LinkedList<PackageInfo> packageInfos = new LinkedList<PackageInfo>();
        for (Dependency packageDependency : packageDependencies) {
            PackageInfo packageInfo = null;
            for (PackageInfo packageInfo2 : this.knownPackageInfos) {
                if (!packageDependency.matches(packageInfo2.getId())) continue;
                log.debug((CharSequence)("Dependency is already resolved from project dependencies: " + packageDependency));
                packageInfo = packageInfo2;
            }
            if (packageInfo == null) {
                for (Map.Entry entry : packageLocations.entrySet()) {
                    if (!packageDependency.matches((PackageId)entry.getKey())) continue;
                    Artifact artifact = MavenBasedPackageDependency.uriToMavenCoordinates((URI)entry.getValue());
                    packageInfo = this.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), log);
                }
            }
            if (packageInfo == null) {
                packageInfo = this.resolve(packageDependency, log);
            }
            if (packageInfo == null) continue;
            packageInfos.add(packageInfo);
        }
        return packageInfos;
    }

    @Nullable
    public PackageInfo resolve(Dependency dependency, Log log) throws IOException {
        String artifactId;
        String groupId;
        Artifact artifact = this.mapPackageDependencyToMavenArtifact.get(new Dependency(dependency.getGroup(), dependency.getName(), null));
        if (artifact == AbstractValidateMojo.IGNORE_ARTIFACT) {
            return null;
        }
        log.info((CharSequence)("Trying to resolve dependency '" + dependency + "' from Maven repository"));
        if (artifact != null) {
            groupId = artifact.getGroupId();
            artifactId = artifact.getArtifactId();
        } else {
            groupId = dependency.getGroup();
            artifactId = dependency.getName();
        }
        PackageInfo info = null;
        if (dependency.getRange().isLowInclusive()) {
            info = this.resolve(groupId, artifactId, dependency.getRange().getLow().toString(), log);
        }
        if (info == null && dependency.getRange().isHighInclusive()) {
            info = this.resolve(groupId, artifactId, dependency.getRange().getHigh().toString(), log);
        }
        if (info == null && VersionRange.INFINITE.equals((Object)dependency.getRange())) {
            info = this.resolve(groupId, artifactId, "LATEST", log);
        }
        if (info == null) {
            log.warn((CharSequence)("Could not resolve dependency from any Maven Repository for dependency " + dependency));
            return null;
        }
        return info;
    }

    @Nullable
    private PackageInfo resolve(String groupId, String artifactId, String version, Log log) throws IOException {
        Artifact artifact = this.repositorySystem.createArtifact(groupId, artifactId, version, "zip");
        File file = this.resolve(artifact, log);
        if (file != null) {
            return DefaultPackageInfo.read((File)file);
        }
        return null;
    }

    @Nullable
    private File resolve(Artifact artifact, Log log) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest(this.repositoryRequest);
        resolutionRequest.setArtifact(artifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(resolutionRequest);
        if (result.isSuccess()) {
            log.debug((CharSequence)("Successfully resolved artifact " + artifact.getArtifactId()));
            Artifact resolvedArtifact = (Artifact)result.getArtifacts().iterator().next();
            return resolvedArtifact.getFile();
        }
        try {
            this.resolutionErrorHandler.throwErrors(resolutionRequest, result);
        }
        catch (ArtifactResolutionException e) {
            log.debug((Throwable)e);
        }
        return null;
    }
}

