/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.util.List;
import org.apache.jackrabbit.filevault.maven.packaging.impl.StringFilter;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;

public class StringFilterSet
extends FilterSet<StringFilter> {
    public void addEntry(String pattern) throws ConfigurationException {
        if (pattern.startsWith("~")) {
            this.addExclude((Filter)new StringFilter(pattern.substring(1)));
        } else {
            this.addInclude((Filter)new StringFilter(pattern));
        }
    }

    public void addEntries(String patterns) throws ConfigurationException {
        for (String name : patterns.split(",")) {
            this.addEntry(name.trim());
        }
    }

    public boolean contains(String path) {
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !((FilterSet.Entry)entries.get(0)).isInclude();
        for (FilterSet.Entry entry : entries) {
            if (!((StringFilter)entry.getFilter()).matches(path)) continue;
            result = entry.isInclude();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String delim = "";
        for (FilterSet.Entry entry : this.getEntries()) {
            builder.append(delim);
            if (!entry.isInclude()) {
                builder.append("~");
            }
            builder.append(entry.getFilter());
            delim = ",";
        }
        return builder.toString();
    }
}

