/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class FileValidator {
    public boolean isContainingIndexDef;
    List<String> indexPaths = new ArrayList<String>();
    Map<String, String> foundIndexes = new HashMap<String, String>();

    public void lookupIndexDefinitionInArtifact(InputStream artifactFileInputStream, String artifactName) throws IOException, MojoExecutionException {
        if (artifactName.endsWith("zip")) {
            ZipInputStream zipArtifactStream = new ZipInputStream(artifactFileInputStream);
            String entryName = "";
            ZipEntry entry = zipArtifactStream.getNextEntry();
            while (entry != null) {
                entryName = entry.getName();
                if (entryName.endsWith("zip")) {
                    this.lookupIndexDefinitionInArtifact(zipArtifactStream, artifactName + "/" + entryName);
                } else if ("META-INF/vault/filter.xml".equals(entryName) || entryName.contains("/_oak_index/")) {
                    this.parseXMLForIndexDefinition(zipArtifactStream, entryName, artifactName + "/" + entryName);
                }
                entry = zipArtifactStream.getNextEntry();
            }
        } else if ("META-INF/vault/filter.xml".equals(artifactName) || artifactName.contains("/_oak_index/")) {
            this.parseXMLForIndexDefinition(artifactFileInputStream, artifactName, artifactName);
        }
    }

    private void parseXMLForIndexDefinition(InputStream xmlInputStream, String entryName, String absoluteEntryName) throws MojoExecutionException {
        try {
            Document xml = Jsoup.parse((InputStream)xmlInputStream, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
            if ("META-INF/vault/filter.xml".equals(entryName)) {
                for (Element filter : xml.select("filter[root]")) {
                    String root = filter.attr("root");
                    int oakIndexPosition = root.indexOf("/oak:index");
                    if (oakIndexPosition < 0) continue;
                    this.isContainingIndexDef = true;
                    int nextSlash = root.indexOf("/", oakIndexPosition + "oak:index".length() + 2);
                    String baseIndexPath = nextSlash > -1 ? root.substring(0, nextSlash) : root;
                    this.indexPaths.add(baseIndexPath);
                }
            } else if (entryName.contains("/_oak_index/")) {
                String basePath = entryName.substring(8).replace("_oak_index", "oak:index").replace("/.content.xml", "");
                for (Element element : xml.select("*[jcr:primaryType$=oak:QueryIndexDefinition]")) {
                    String xmlPath = FileValidator.getXmlPath(element);
                    String jcrPath = StringUtils.removeStart((String)xmlPath, (String)"/jcr:root");
                    this.foundIndexes.put(basePath + jcrPath, absoluteEntryName);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while trying to parse xml " + absoluteEntryName, e);
        }
    }

    private static String getXmlPath(Element element) {
        if (element.ownerDocument() == element) {
            return "";
        }
        return FileValidator.getXmlPath(element.parent()) + "/" + element.nodeName();
    }

    public String getMessageWithPathsOfIndexDef() {
        StringBuilder msg = new StringBuilder();
        for (String path : this.indexPaths) {
            String completePath = this.foundIndexes.get(path);
            if (completePath != null) {
                msg.append(" Package contains index ").append(path).append(" in ").append(completePath).append(".").append(System.lineSeparator());
                continue;
            }
            msg.append(" Package contains index ").append(path).append(" in filter, but not in package. Existing index will be removed.").append(System.lineSeparator());
        }
        return msg.toString();
    }
}

