/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.ContentPackageArchiver;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.filevault.maven.packaging.impl.FileValidator;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VaultMojo
extends AbstractPackageMojo {
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Deprecated
    @Parameter
    private File builtContentDirectory;
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter(property="vault.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(property="vault.excludes", defaultValue="**/.vlt,**/.vltignore,**/.DS_Store", required=true)
    private String[] excludes;

    @Nonnull
    private FileSet createFileSet(@Nonnull File directory, @Nonnull String prefix) {
        return this.createFileSet(directory, prefix, null);
    }

    @Nonnull
    private FileSet createFileSet(@Nonnull File directory, @Nonnull String prefix, List<String> additionalExcludes) {
        LinkedList<String> excludes = new LinkedList<String>(Arrays.asList(this.excludes));
        if (additionalExcludes != null) {
            excludes.addAll(additionalExcludes);
        }
        return (FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)directory).prefixed(prefix)).includeExclude(null, excludes.toArray(new String[excludes.size()]))).includeEmptyDirs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
        try {
            File metaInfDirectory = this.getMetaInfDir();
            File jcrSourceDirectory = null;
            if (this.builtContentDirectory != null) {
                this.getLog().warn((CharSequence)"The 'builtContentDirectory' is deprecated. Please use the new 'jcrRootSourceDirectory' instead.");
                jcrSourceDirectory = this.builtContentDirectory;
            } else {
                jcrSourceDirectory = VaultMojo.getFirstExistingDirectory(this.jcrRootSourceDirectory);
            }
            if (jcrSourceDirectory != null) {
                this.getLog().info((CharSequence)("packaging content from " + jcrSourceDirectory.getPath()));
            }
            Filters filters = this.loadFilterFile();
            Map<String, File> embeddedFiles = this.getEmbeddedFilesMap();
            ContentPackageArchiver contentPackageArchiver = new ContentPackageArchiver();
            contentPackageArchiver.setIncludeEmptyDirs(true);
            if (metaInfDirectory != null) {
                File filterXML = this.getFilterFile();
                if (filterXML.exists()) {
                    contentPackageArchiver.addFile(filterXML, "META-INF/vault/filter.xml");
                }
                contentPackageArchiver.addFileSet(this.createFileSet(metaInfDirectory, "META-INF/vault/"));
            }
            contentPackageArchiver.addFileSet(this.createFileSet(this.workDirectory, "", Collections.singletonList("META-INF/MANIFEST.MF")));
            contentPackageArchiver.addFileSet(this.createFileSet(this.workDirectory, "", null));
            if (jcrSourceDirectory != null && jcrSourceDirectory.exists()) {
                List filterSets = filters.getFilterSets();
                if (filterSets.isEmpty()) {
                    contentPackageArchiver.addFileSet(this.createFileSet(jcrSourceDirectory, FileUtils.normalize((String)("jcr_root/" + this.prefix))));
                } else {
                    Iterator iterator = filterSets.iterator();
                    while (iterator.hasNext()) {
                        PathFilterSet filterSet = (PathFilterSet)iterator.next();
                        String relPath = PlatformNameFormat.getPlatformPath((String)filterSet.getRoot());
                        String rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath));
                        if (embeddedFiles.containsKey(rootPath)) continue;
                        File fullCoverage = new File(jcrSourceDirectory, relPath + ".xml");
                        if (fullCoverage.isFile()) {
                            rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath + ".xml"));
                            contentPackageArchiver.addFile(fullCoverage, rootPath);
                            continue;
                        }
                        File rootDirectory = new File(jcrSourceDirectory, relPath);
                        while (!(rootDirectory.exists() && rootDirectory.isDirectory() || jcrSourceDirectory.equals(rootDirectory))) {
                            rootDirectory = rootDirectory.getParentFile();
                            relPath = StringUtils.chomp((String)relPath, (String)"/");
                        }
                        if (jcrSourceDirectory.equals(rootDirectory)) continue;
                        rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath));
                        contentPackageArchiver.addFileSet(this.createFileSet(rootDirectory, rootPath + "/"));
                    }
                }
            }
            for (Map.Entry entry : embeddedFiles.entrySet()) {
                contentPackageArchiver.addFile((File)entry.getValue(), (String)entry.getKey());
            }
            if (!this.allowIndexDefinitions) {
                FileValidator fileValidator = new FileValidator();
                this.getLog().info((CharSequence)"Scanning files for oak index definitions.");
                for (ArchiveEntry entry : contentPackageArchiver.getFiles().values()) {
                    if (entry.getType() != 1) continue;
                    InputStream in = null;
                    try {
                        in = entry.getInputStream();
                        String sanitizedFileName = FilenameUtils.separatorsToUnix((String)entry.getName());
                        fileValidator.lookupIndexDefinitionInArtifact(in, sanitizedFileName);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (fileValidator.isContainingIndexDef) {
                    this.getLog().error((CharSequence)fileValidator.getMessageWithPathsOfIndexDef());
                    throw new MojoExecutionException("Package should not contain index definitions, because 'allowIndexDefinitions=false'.");
                }
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)contentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(null, this.project, this.getMavenArchiveConfiguration(this.getManifestFile()));
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(finalFile);
            artifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(File manifestFile) throws IOException {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
        }
        this.archive.setManifestFile(manifestFile);
        return this.archive;
    }
}

