/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tsfile.exception.PathParseException;
import org.apache.tsfile.read.common.parser.PathNodesGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathCheckExample {
    private static final List<String> INPUT_LIST = new ArrayList<String>();
    private static final String DIR = "/Users/root/iotdb/tools";
    private static final Logger LOGGER = LoggerFactory.getLogger(PathCheckExample.class);
    private static final int CONCURRENCY = 5;

    public static void main(String[] args) {
        PathCheckExample.batchCheck();
        PathCheckExample.dirCheck();
    }

    private static void batchCheck() {
        INPUT_LIST.add("root.test.d1.s1");
        INPUT_LIST.add("root.b+.d1.s2");
        INPUT_LIST.add("root.test.1.s3");
        INPUT_LIST.add("root.test.d-j.s4");
        INPUT_LIST.add("root.test.'8`7'.s5");
        INPUT_LIST.add("root.test.`1`.s6");
        INPUT_LIST.add("root.test.\"d+b\".s7");
        for (String path : INPUT_LIST) {
            PathCheckExample.checkPath(path);
        }
    }

    private static void checkPath(String path) {
        try {
            PathNodesGenerator.checkPath((String)path);
        }
        catch (PathParseException e) {
            LOGGER.error("{} is not a legal path.", (Object)path);
        }
    }

    public static void dirCheck() {
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        File dir = new File(DIR);
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.getName().startsWith("dump") || !file.getName().endsWith(".csv")) continue;
            Future<Void> future = executorService.submit(new CheckThread(file));
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error when checking paths.");
            Thread.currentThread().interrupt();
        }
        executorService.shutdown();
    }

    static class CheckThread
    implements Callable<Void> {
        File file;

        public CheckThread(File file) {
            this.file = file;
        }

        @Override
        public Void call() {
            try (BufferedReader br = new BufferedReader(new FileReader(this.file));){
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] split = line.split(",");
                    String path = split[0];
                    PathCheckExample.checkPath(path);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading file: {}", (Object)this.file.getName());
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

