/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLClient.class);
    private static SSLConnectionSocketFactory sslConnectionSocketFactory = null;
    private static PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = null;

    public static SSLClient getInstance() {
        return SSLClientInstance.instance;
    }

    private SSLClient() {
        SSLClient.build();
    }

    private static void build() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            });
            PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), new String[]{"TLSv1.3"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registryBuilder = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslConnectionSocketFactory).build();
            poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registryBuilder);
            poolingHttpClientConnectionManager.setMaxTotal(10);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.error("Build error", (Throwable)e);
        }
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setConnectionManagerShared(true).build();
    }

    private static class SSLClientInstance {
        private static final SSLClient instance = new SSLClient();

        private SSLClientInstance() {
        }
    }
}

