/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import org.apache.iotdb.commons.conf.CommonDescriptor;

public class CommonDateTimeUtils {
    public static long convertMilliTimeWithPrecision(long milliTime, String timePrecision) {
        long result = milliTime;
        switch (timePrecision) {
            case "ns": {
                result = milliTime * 1000000L;
                break;
            }
            case "us": {
                result = milliTime * 1000L;
                break;
            }
        }
        return result;
    }

    public static long currentTime() {
        String timePrecision;
        long startupNano = CommonDescriptor.getInstance().getConfig().getStartUpNanosecond();
        switch (timePrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                return System.currentTimeMillis() * 1000000L + (System.nanoTime() - startupNano) % 1000000L;
            }
            case "us": {
                return System.currentTimeMillis() * 1000L + (System.nanoTime() - startupNano) / 1000L % 1000L;
            }
        }
        return System.currentTimeMillis();
    }
}

