/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin.extractor.iotdb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.metric.PipeFakeEventCounter;
import org.apache.iotdb.commons.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBMetaExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBMetaExtractor.class);
    private final AtomicBoolean hasBeenStarted;
    protected final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue(new PipeFakeEventCounter());
    private boolean enableSchemaSync = false;
    private boolean enableTtlSync = false;
    private boolean enableFunctionSync = false;
    private boolean enableTriggerSync = false;
    private boolean enableModelSync = false;
    private boolean enableAuthoritySync = false;
    private boolean atLeastOneEnable = false;

    public IoTDBMetaExtractor() {
        this.hasBeenStarted = new AtomicBoolean(false);
    }

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validate(arg -> {
            HashSet<String> inclusionList = new HashSet<String>(Arrays.asList(((String)arg).replace(" ", "").split(",")));
            if (inclusionList.contains("schema")) {
                this.enableSchemaSync = true;
            }
            if (inclusionList.contains("ttl")) {
                this.enableTtlSync = true;
            }
            if (inclusionList.contains("function")) {
                this.enableFunctionSync = true;
            }
            if (inclusionList.contains("trigger")) {
                this.enableTriggerSync = true;
            }
            if (inclusionList.contains("model")) {
                this.enableModelSync = true;
            }
            if (inclusionList.contains("authority")) {
                this.enableAuthoritySync = true;
            }
            this.atLeastOneEnable = this.enableSchemaSync || this.enableTtlSync || this.enableFunctionSync || this.enableTriggerSync || this.enableModelSync || this.enableAuthoritySync;
            return this.atLeastOneEnable || inclusionList.contains("data");
        }, String.format("At least one of %s, %s, %s, %s, %s, %s, %s should be present in %s.", "data", "schema", "ttl", "function", "trigger", "model", "authority", "source.inclusion"), (Object)validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data, schema"));
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
    }

    public final void extract(Event event) {
        this.pendingQueue.waitedOffer(event);
    }

    public Event supply() throws Exception {
        return this.pendingQueue.directPoll();
    }

    public void close() throws Exception {
    }
}

