/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.donothing.DoNothingConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift.IoTDBLegacyPipeConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift.IoTDBThriftAsyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift.IoTDBThriftConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift.IoTDBThriftSslConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift.IoTDBThriftSyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.websocket.WebSocketConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.writeback.WriteBackConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.extractor.donothing.DoNothingExtractor;
import org.apache.iotdb.commons.pipe.plugin.builtin.extractor.iotdb.IoTDBExtractor;
import org.apache.iotdb.commons.pipe.plugin.builtin.processor.donothing.DoNothingProcessor;
import org.apache.iotdb.commons.pipe.plugin.builtin.processor.downsampling.DownSamplingProcessor;

public enum BuiltinPipePlugin {
    DO_NOTHING_EXTRACTOR("do-nothing-extractor", DoNothingExtractor.class),
    IOTDB_EXTRACTOR("iotdb-extractor", IoTDBExtractor.class),
    DO_NOTHING_SOURCE("do-nothing-source", DoNothingExtractor.class),
    IOTDB_SOURCE("iotdb-source", IoTDBExtractor.class),
    DO_NOTHING_PROCESSOR("do-nothing-processor", DoNothingProcessor.class),
    DOWN_SAMPLING_PROCESSOR("down-sampling-processor", DownSamplingProcessor.class),
    DO_NOTHING_CONNECTOR("do-nothing-connector", DoNothingConnector.class),
    IOTDB_THRIFT_CONNECTOR("iotdb-thrift-connector", IoTDBThriftConnector.class),
    IOTDB_THRIFT_SSL_CONNECTOR("iotdb-thrift-ssl-connector", IoTDBThriftSslConnector.class),
    IOTDB_THRIFT_SYNC_CONNECTOR("iotdb-thrift-sync-connector", IoTDBThriftSyncConnector.class),
    IOTDB_THRIFT_ASYNC_CONNECTOR("iotdb-thrift-async-connector", IoTDBThriftAsyncConnector.class),
    IOTDB_LEGACY_PIPE_CONNECTOR("iotdb-legacy-pipe-connector", IoTDBLegacyPipeConnector.class),
    WEBSOCKET_CONNECTOR("websocket-connector", WebSocketConnector.class),
    WRITE_BACK_CONNECTOR("write-back-connector", WriteBackConnector.class),
    DO_NOTHING_SINK("do-nothing-sink", DoNothingConnector.class),
    IOTDB_THRIFT_SINK("iotdb-thrift-sink", IoTDBThriftConnector.class),
    IOTDB_THRIFT_SSL_SINK("iotdb-thrift-ssl-sink", IoTDBThriftSslConnector.class),
    IOTDB_THRIFT_SYNC_SINK("iotdb-thrift-sync-sink", IoTDBThriftSyncConnector.class),
    IOTDB_THRIFT_ASYNC_SINK("iotdb-thrift-async-sink", IoTDBThriftAsyncConnector.class),
    IOTDB_LEGACY_PIPE_SINK("iotdb-legacy-pipe-sink", IoTDBLegacyPipeConnector.class),
    WEBSOCKET_SINK("websocket-sink", WebSocketConnector.class),
    WRITE_BACK_SINK("write-back-sink", WriteBackConnector.class);

    private final String pipePluginName;
    private final Class<?> pipePluginClass;
    private final String className;
    public static final Set<String> SHOW_PIPE_PLUGINS_BLACKLIST;

    private BuiltinPipePlugin(String pipePluginName, Class<?> pipePluginClass) {
        this.pipePluginName = pipePluginName;
        this.pipePluginClass = pipePluginClass;
        this.className = pipePluginClass.getName();
    }

    public String getPipePluginName() {
        return this.pipePluginName;
    }

    public Class<?> getPipePluginClass() {
        return this.pipePluginClass;
    }

    public String getClassName() {
        return this.className;
    }

    static {
        SHOW_PIPE_PLUGINS_BLACKLIST = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(DO_NOTHING_EXTRACTOR.getPipePluginName().toUpperCase(), IOTDB_EXTRACTOR.getPipePluginName().toUpperCase(), DO_NOTHING_SOURCE.getPipePluginName().toUpperCase(), DOWN_SAMPLING_PROCESSOR.getPipePluginName().toUpperCase(), DO_NOTHING_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_THRIFT_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_THRIFT_SSL_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName().toUpperCase(), WEBSOCKET_CONNECTOR.getPipePluginName().toUpperCase(), WRITE_BACK_CONNECTOR.getPipePluginName().toUpperCase(), IOTDB_THRIFT_SYNC_SINK.getPipePluginName().toUpperCase(), IOTDB_THRIFT_ASYNC_SINK.getPipePluginName().toUpperCase(), IOTDB_LEGACY_PIPE_SINK.getPipePluginName().toUpperCase(), WEBSOCKET_SINK.getPipePluginName().toUpperCase(), WRITE_BACK_SINK.getPipePluginName().toUpperCase())));
    }
}

