/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferSnapshotSealReq
extends TPipeTransferReq {
    private transient String snapshotName;
    private transient long snapshotLength;

    private PipeTransferSnapshotSealReq() {
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public long getSnapshotLength() {
        return this.snapshotLength;
    }

    public static PipeTransferSnapshotSealReq toTPipeTransferReq(String snapshotName, long snapshotLength) throws IOException {
        PipeTransferSnapshotSealReq snapshotSealReq = new PipeTransferSnapshotSealReq();
        snapshotSealReq.snapshotName = snapshotName;
        snapshotSealReq.snapshotLength = snapshotLength;
        snapshotSealReq.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        snapshotSealReq.type = PipeRequestType.TRANSFER_SNAPSHOT_SEAL.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)snapshotName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)snapshotLength, (OutputStream)outputStream);
            snapshotSealReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return snapshotSealReq;
    }

    public static PipeTransferSnapshotSealReq fromTPipeTransferReq(TPipeTransferReq req) {
        PipeTransferSnapshotSealReq snapshotSealReq = new PipeTransferSnapshotSealReq();
        snapshotSealReq.snapshotName = ReadWriteIOUtils.readString((ByteBuffer)req.body);
        snapshotSealReq.snapshotLength = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        snapshotSealReq.version = req.version;
        snapshotSealReq.type = req.type;
        snapshotSealReq.body = req.body;
        return snapshotSealReq;
    }

    public static byte[] toTPipeTransferSnapshotSealBytes(String snapshotName, long snapshotLength) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_SNAPSHOT_SEAL.getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)snapshotName, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)snapshotLength, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferSnapshotSealReq that = (PipeTransferSnapshotSealReq)((Object)obj);
        return this.snapshotName.equals(that.snapshotName) && this.snapshotLength == that.snapshotLength && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotName, this.snapshotLength, this.version, this.type, this.body);
    }
}

