/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

public enum PrivilegeType {
    READ_DATA(true),
    WRITE_DATA(true),
    READ_SCHEMA(true),
    WRITE_SCHEMA(true),
    MANAGE_USER,
    MANAGE_ROLE,
    USE_TRIGGER,
    USE_UDF,
    USE_CQ,
    USE_PIPE,
    USE_MODEL,
    EXTEND_TEMPLATE,
    MANAGE_DATABASE,
    MAINTAIN;

    private static final int PRIVILEGE_COUNT;
    private final boolean isPathRelevant;

    private PrivilegeType() {
        this.isPathRelevant = false;
    }

    private PrivilegeType(boolean isPathRelevant) {
        this.isPathRelevant = isPathRelevant;
    }

    public boolean isPathRelevant() {
        return this.isPathRelevant;
    }

    public static boolean isPathRelevant(int ordinal) {
        return ordinal < 4;
    }

    public static int getSysPriCount() {
        int size = 0;
        for (PrivilegeType item : PrivilegeType.values()) {
            if (item.isPathRelevant()) continue;
            ++size;
        }
        return size;
    }

    public static int getPathPriCount() {
        int size = 0;
        for (PrivilegeType item : PrivilegeType.values()) {
            if (!item.isPathRelevant()) continue;
            ++size;
        }
        return size;
    }

    static {
        PRIVILEGE_COUNT = PrivilegeType.values().length;
    }
}

