/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mqtt;

import java.util.Random;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

public class MQTTClient {
    public static void main(String[] args) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setHost("127.0.0.1", 1883);
        mqtt.setUserName("root");
        mqtt.setPassword("root");
        mqtt.setConnectAttemptsMax(3L);
        mqtt.setReconnectDelay(10L);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            String payload = String.format("{\n\"device\":\"root.sg.d1\",\n\"timestamp\":%d,\n\"measurements\":[\"s1\"],\n\"values\":[%f]\n}", System.currentTimeMillis(), random.nextDouble());
            sb.append(payload).append(",");
            Thread.sleep(1L);
            connection.publish("root.sg.d1.s1", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        }
        sb.insert(0, "[");
        sb.replace(sb.lastIndexOf(","), sb.length(), "]");
        connection.publish("root.sg.d1.s1", sb.toString().getBytes(), QoS.AT_LEAST_ONCE, false);
        connection.disconnect();
    }
}

