/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.PriorityQueue;
import org.apache.iotdb.library.drepair.util.ValueRepair;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.RowIterator;

public class LsGreedy
extends ValueRepair {
    private double center = 0.0;
    private double sigma;
    private static final double EPSILON = 1.0E-12;

    public LsGreedy(RowIterator dataIterator) throws Exception {
        super(dataIterator);
        this.setParameters();
    }

    private void setParameters() {
        double[] speed = Util.speed(this.original, this.time);
        double[] speedchange = Util.variation(speed);
        this.sigma = Util.mad(speedchange);
    }

    @Override
    public void repair() {
        RepairNode top;
        this.repaired = (double[])this.original.clone();
        RepairNode[] table = new RepairNode[this.n];
        PriorityQueue<RepairNode> heap = new PriorityQueue<RepairNode>();
        for (int i = 1; i < this.n - 1; ++i) {
            RepairNode node;
            table[i] = node = new RepairNode(i);
            if (!(Math.abs(node.getU() - this.center) > 3.0 * this.sigma)) continue;
            heap.add(node);
        }
        while ((top = (RepairNode)heap.peek()) != null && !(Math.abs(top.getU() - this.center) < Math.max(1.0E-12, 3.0 * this.sigma))) {
            top.modify();
            for (int i = Math.max(1, top.getIndex() - 1); i <= Math.min(this.n - 2, top.getIndex() + 1); ++i) {
                RepairNode temp;
                heap.remove(table[i]);
                table[i] = temp = new RepairNode(i);
                if (!(Math.abs(temp.getU() - this.center) > 3.0 * this.sigma)) continue;
                heap.add(temp);
            }
        }
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    class RepairNode
    implements Comparable<RepairNode> {
        private final int index;
        private final double u;

        public RepairNode(int index) {
            this.index = index;
            double v1 = LsGreedy.this.repaired[index + 1] - LsGreedy.this.repaired[index];
            double v2 = LsGreedy.this.repaired[index] - LsGreedy.this.repaired[index - 1];
            this.u = (v1 /= (double)(LsGreedy.this.time[index + 1] - LsGreedy.this.time[index])) - (v2 /= (double)(LsGreedy.this.time[index] - LsGreedy.this.time[index - 1]));
        }

        public void modify() {
            double temp = LsGreedy.this.sigma < 1.0E-12 ? Math.abs(this.u - LsGreedy.this.center) : Math.max(LsGreedy.this.sigma, Math.abs(this.u - LsGreedy.this.center) / 3.0);
            temp *= (double)(LsGreedy.this.time[this.index + 1] - LsGreedy.this.time[this.index]) * (double)(LsGreedy.this.time[this.index] - LsGreedy.this.time[this.index - 1]) / (double)(LsGreedy.this.time[this.index + 1] - LsGreedy.this.time[this.index - 1]);
            if (this.u > LsGreedy.this.center) {
                int n = this.index;
                LsGreedy.this.repaired[n] = LsGreedy.this.repaired[n] + temp;
            } else {
                int n = this.index;
                LsGreedy.this.repaired[n] = LsGreedy.this.repaired[n] - temp;
            }
        }

        @Override
        public int compareTo(RepairNode o) {
            double u2;
            double u1 = Math.abs(this.u - LsGreedy.this.center);
            if (u1 > (u2 = Math.abs(o.u - LsGreedy.this.center))) {
                return -1;
            }
            if (u1 == u2) {
                return 0;
            }
            return 1;
        }

        public int getIndex() {
            return this.index;
        }

        public double getU() {
            return this.u;
        }
    }
}

