/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCCharsetExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCCharsetExample.class);

    public static void main(String[] args) throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667?charset=GB18030", "root", "root");
             IoTDBStatement statement = (IoTDBStatement)connection.createStatement();){
            String insertSQLWithGB18030 = "insert into root.\u6d4b\u8bd5(timestamp, \u5f5d\u8bed, \u7e41\u4f53, \u8499\u6587, \u7b80\u4f53, \u6807\u70b9\u7b26\u53f7, \u85cf\u8bed) values(1, '\ua188\ua320\ua259', \"\u7e41\u9ad4\", '\u182e\u1823\u1829\u182d\u1823\u182f \u182c\u1821\u182f\u1821', '\u7b80\u4f53', '\u2014\u2014\uff1f\uff01', \"\u0f56\u0f7c\u0f51\u0f0b\u0f66\u0f90\u0f51\u0f0d\");";
            byte[] insertSQLWithGB18030Bytes = "insert into root.\u6d4b\u8bd5(timestamp, \u5f5d\u8bed, \u7e41\u4f53, \u8499\u6587, \u7b80\u4f53, \u6807\u70b9\u7b26\u53f7, \u85cf\u8bed) values(1, '\ua188\ua320\ua259', \"\u7e41\u9ad4\", '\u182e\u1823\u1829\u182d\u1823\u182f \u182c\u1821\u182f\u1821', '\u7b80\u4f53', '\u2014\u2014\uff1f\uff01', \"\u0f56\u0f7c\u0f51\u0f0b\u0f66\u0f90\u0f51\u0f0d\");".getBytes("GB18030");
            statement.execute(insertSQLWithGB18030Bytes);
        }
        catch (IoTDBSQLException e) {
            LOGGER.error("IoTDB Jdbc example error", (Throwable)e);
        }
        JDBCCharsetExample.outputResult("GB18030");
        JDBCCharsetExample.outputResult("UTF-8");
        JDBCCharsetExample.outputResult("UTF-16");
        JDBCCharsetExample.outputResult("GBK");
        JDBCCharsetExample.outputResult("ISO-8859-1");
    }

    private static void outputResult(String charset) throws SQLException {
        System.out.println("[Charset: " + charset + "]");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667?charset=" + charset, "root", "root");
             IoTDBStatement statement = (IoTDBStatement)connection.createStatement();){
            JDBCCharsetExample.outputResult(statement.executeQuery("select ** from root"), Charset.forName(charset));
        }
        catch (IoTDBSQLException e) {
            LOGGER.error("IoTDB Jdbc example error", (Throwable)e);
        }
    }

    private static void outputResult(ResultSet resultSet, Charset charset) throws SQLException {
        if (resultSet != null) {
            int i;
            System.out.println("--------------------------");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                System.out.print(metaData.getColumnLabel(i + 1) + " ");
            }
            System.out.println();
            block1: while (resultSet.next()) {
                i = 1;
                while (true) {
                    System.out.print(resultSet.getString(i) + " (" + new String(resultSet.getBytes(i), charset) + ")");
                    if (i >= columnCount) {
                        System.out.println();
                        continue block1;
                    }
                    System.out.print(", ");
                    ++i;
                }
            }
            System.out.println("--------------------------\n");
        }
    }
}

