/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer.tree;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.subscription.config.ConsumerConstant;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.session.subscription.consumer.AsyncCommitCallback;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTreePullConsumer;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionProvider;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionPullConsumer;
import org.apache.iotdb.session.subscription.consumer.tree.SubscriptionTreeProvider;
import org.apache.iotdb.session.subscription.consumer.tree.SubscriptionTreePullConsumerBuilder;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.apache.thrift.annotation.Nullable;

public class SubscriptionTreePullConsumer
extends AbstractSubscriptionPullConsumer
implements ISubscriptionTreePullConsumer {
    @Override
    protected AbstractSubscriptionProvider constructSubscriptionProvider(TEndPoint endPoint, String username, String password, String consumerId, String consumerGroupId, int thriftMaxFrameSize) {
        return new SubscriptionTreeProvider(endPoint, username, password, consumerId, consumerGroupId, thriftMaxFrameSize);
    }

    protected SubscriptionTreePullConsumer(SubscriptionTreePullConsumerBuilder builder) {
        super(builder);
    }

    @Deprecated
    private SubscriptionTreePullConsumer(Builder builder) {
        super(((SubscriptionTreePullConsumerBuilder)new SubscriptionTreePullConsumerBuilder().host(builder.host).port(builder.port).nodeUrls(builder.nodeUrls)).username(builder.username).password(builder.password).consumerId(builder.consumerId).consumerGroupId(builder.consumerGroupId).heartbeatIntervalMs(builder.heartbeatIntervalMs).endpointsSyncIntervalMs(builder.endpointsSyncIntervalMs).fileSaveDir(builder.fileSaveDir).fileSaveFsync(builder.fileSaveFsync).thriftMaxFrameSize(builder.thriftMaxFrameSize).maxPollParallelism(builder.maxPollParallelism).autoCommit(builder.autoCommit).autoCommitIntervalMs(builder.autoCommitIntervalMs));
    }

    public SubscriptionTreePullConsumer(Properties properties) {
        this(properties, (Boolean)properties.getOrDefault((Object)"auto-commit", (Object)true), (Long)properties.getOrDefault((Object)"auto-commit-interval-ms", (Object)5000L));
    }

    private SubscriptionTreePullConsumer(Properties properties, boolean autoCommit, long autoCommitIntervalMs) {
        super(properties, autoCommit, autoCommitIntervalMs);
    }

    @Override
    public void open() throws SubscriptionException {
        super.open();
    }

    @Override
    public void close() throws SubscriptionException {
        super.close();
    }

    @Override
    public void subscribe(String topicName) throws SubscriptionException {
        super.subscribe(topicName);
    }

    @Override
    public void subscribe(String ... topicNames) throws SubscriptionException {
        super.subscribe(topicNames);
    }

    @Override
    public void subscribe(Set<String> topicNames) throws SubscriptionException {
        super.subscribe(topicNames);
    }

    @Override
    public void unsubscribe(String topicName) throws SubscriptionException {
        super.unsubscribe(topicName);
    }

    @Override
    public void unsubscribe(String ... topicNames) throws SubscriptionException {
        super.unsubscribe(topicNames);
    }

    @Override
    public void unsubscribe(Set<String> topicNames) throws SubscriptionException {
        super.unsubscribe(topicNames);
    }

    @Override
    public List<SubscriptionMessage> poll(Duration timeout) throws SubscriptionException {
        return super.poll(timeout);
    }

    @Override
    public List<SubscriptionMessage> poll(long timeoutMs) throws SubscriptionException {
        return super.poll(timeoutMs);
    }

    @Override
    public List<SubscriptionMessage> poll(Set<String> topicNames, Duration timeout) throws SubscriptionException {
        return super.poll(topicNames, timeout);
    }

    @Override
    public List<SubscriptionMessage> poll(Set<String> topicNames, long timeoutMs) {
        return super.poll(topicNames, timeoutMs);
    }

    @Override
    public void commitSync(SubscriptionMessage message) throws SubscriptionException {
        super.commitSync(message);
    }

    @Override
    public void commitSync(Iterable<SubscriptionMessage> messages) throws SubscriptionException {
        super.commitSync(messages);
    }

    @Override
    public CompletableFuture<Void> commitAsync(SubscriptionMessage message) {
        return super.commitAsync(message);
    }

    @Override
    public CompletableFuture<Void> commitAsync(Iterable<SubscriptionMessage> messages) {
        return super.commitAsync(messages);
    }

    @Override
    public void commitAsync(SubscriptionMessage message, AsyncCommitCallback callback) {
        super.commitAsync(message, callback);
    }

    @Override
    public void commitAsync(Iterable<SubscriptionMessage> messages, AsyncCommitCallback callback) {
        super.commitAsync(messages, callback);
    }

    @Override
    public String getConsumerId() {
        return super.getConsumerId();
    }

    @Override
    public String getConsumerGroupId() {
        return super.getConsumerGroupId();
    }

    @Deprecated
    public static class Builder {
        private String host;
        private Integer port;
        private List<String> nodeUrls;
        private String username = "root";
        private String password = "root";
        private String consumerId;
        private String consumerGroupId;
        private long heartbeatIntervalMs = 30000L;
        private long endpointsSyncIntervalMs = 120000L;
        private String fileSaveDir = ConsumerConstant.FILE_SAVE_DIR_DEFAULT_VALUE;
        private boolean fileSaveFsync = false;
        private int thriftMaxFrameSize = 0x4000000;
        private int maxPollParallelism = 1;
        private boolean autoCommit = true;
        private long autoCommitIntervalMs = 5000L;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder consumerId(@Nullable String consumerId) {
            if (Objects.isNull(consumerId)) {
                return this;
            }
            this.consumerId = IdentifierUtils.checkAndParseIdentifier(consumerId);
            return this;
        }

        public Builder consumerGroupId(@Nullable String consumerGroupId) {
            if (Objects.isNull(consumerGroupId)) {
                return this;
            }
            this.consumerGroupId = IdentifierUtils.checkAndParseIdentifier(consumerGroupId);
            return this;
        }

        public Builder heartbeatIntervalMs(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = Math.max(heartbeatIntervalMs, 1000L);
            return this;
        }

        public Builder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
            this.endpointsSyncIntervalMs = Math.max(endpointsSyncIntervalMs, 5000L);
            return this;
        }

        public Builder fileSaveDir(String fileSaveDir) {
            this.fileSaveDir = fileSaveDir;
            return this;
        }

        public Builder fileSaveFsync(boolean fileSaveFsync) {
            this.fileSaveFsync = fileSaveFsync;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder maxPollParallelism(int maxPollParallelism) {
            this.maxPollParallelism = Math.max(maxPollParallelism, 1);
            return this;
        }

        public Builder autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder autoCommitIntervalMs(long autoCommitIntervalMs) {
            this.autoCommitIntervalMs = Math.max(autoCommitIntervalMs, 500L);
            return this;
        }

        public SubscriptionTreePullConsumer buildPullConsumer() {
            return new SubscriptionTreePullConsumer(this);
        }
    }
}

