/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class Identifier
extends Expression {
    private static final CharMatcher FIRST_CHAR_DISALLOWED_MATCHER = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    private static final CharMatcher ALLOWED_CHARS_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private final String value;
    private final boolean delimited;

    public Identifier(NodeLocation location, String value, boolean delimited) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = delimited;
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
        Preconditions.checkArgument((delimited || Identifier.isValidIdentifier(value) ? 1 : 0) != 0, (String)"value contains illegal characters: %s", (Object)value);
    }

    public Identifier(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = !Identifier.isValidIdentifier(value);
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
    }

    public Identifier(String value, boolean delimited) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = delimited;
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
        Preconditions.checkArgument((delimited || Identifier.isValidIdentifier(value) ? 1 : 0) != 0, (String)"value contains illegal characters: %s", (Object)value);
    }

    public Identifier(String value) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = !Identifier.isValidIdentifier(value);
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    public String getCanonicalValue() {
        if (this.isDelimited()) {
            return this.value;
        }
        return this.value.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIdentifier(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Identifier.sameClass(this, other)) {
            return false;
        }
        Identifier that = (Identifier)other;
        return Objects.equals(this.value, that.value) && this.delimited == that.delimited;
    }

    private static boolean isValidIdentifier(String value) {
        Verify.verify((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Identifier cannot be empty or null", (Object[])new Object[0]);
        if (FIRST_CHAR_DISALLOWED_MATCHER.matches(value.charAt(0))) {
            return false;
        }
        return ALLOWED_CHARS_MATCHER.matchesAllOf((CharSequence)value);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.IDENTIFIER;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.delimited, (ByteBuffer)buffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.delimited, (OutputStream)stream);
    }

    public Identifier(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.delimited = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

