/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.TimeRange;

public class DeleteDataStatement
extends Statement {
    private List<MeasurementPath> pathList;
    private long deleteStartTime;
    private long deleteEndTime;

    public DeleteDataStatement() {
        this.statementType = StatementType.DELETE;
    }

    public List<MeasurementPath> getPaths() {
        return this.getPathList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<MeasurementPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_DATA), checkedPaths, PrivilegeType.WRITE_DATA);
    }

    public List<MeasurementPath> getPathList() {
        return this.pathList;
    }

    public void setPathList(List<MeasurementPath> pathList) {
        this.pathList = pathList;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public void setDeleteStartTime(long deleteStartTime) {
        this.deleteStartTime = deleteStartTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    public void setDeleteEndTime(long deleteEndTime) {
        this.deleteEndTime = deleteEndTime;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.deleteStartTime = timeRange.getMin();
        this.deleteEndTime = timeRange.getMax();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteData(this, context);
    }
}

