/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.IPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TableLogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableDistributedPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.DataNodeLocationSupplierFactory;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite.StatementRewrite;
import org.apache.iotdb.db.queryengine.plan.scheduler.ClusterScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public class TableModelPlanner
implements IPlanner {
    private final Statement statement;
    private final SqlParser sqlParser;
    private final Metadata metadata;
    private final StatementRewrite statementRewrite;
    private final List<PlanOptimizer> logicalPlanOptimizers;
    private final List<PlanOptimizer> distributionPlanOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final AccessControl accessControl;
    private final WarningCollector warningCollector = WarningCollector.NOOP;
    private final ScheduledExecutorService scheduledExecutor;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager;
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private final DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier;

    public TableModelPlanner(Statement statement, SqlParser sqlParser, Metadata metadata, ScheduledExecutorService scheduledExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager, StatementRewrite statementRewrite, List<PlanOptimizer> logicalPlanOptimizers, List<PlanOptimizer> distributionPlanOptimizers, AccessControl accessControl, DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier) {
        this.statement = statement;
        this.sqlParser = sqlParser;
        this.metadata = metadata;
        this.scheduledExecutor = scheduledExecutor;
        this.syncInternalServiceClientManager = syncInternalServiceClientManager;
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.statementRewrite = statementRewrite;
        this.logicalPlanOptimizers = logicalPlanOptimizers;
        this.distributionPlanOptimizers = distributionPlanOptimizers;
        this.accessControl = accessControl;
        this.dataNodeLocationSupplier = dataNodeLocationSupplier;
    }

    @Override
    public IAnalysis analyze(MPPQueryContext context) {
        return new Analyzer(context, context.getSession(), new StatementAnalyzerFactory(this.metadata, this.sqlParser, this.accessControl), Collections.emptyList(), Collections.emptyMap(), this.statementRewrite, this.warningCollector).analyze(this.statement);
    }

    @Override
    public LogicalQueryPlan doLogicalPlan(IAnalysis analysis, MPPQueryContext context) {
        return new TableLogicalPlanner(context, this.metadata, context.getSession(), this.symbolAllocator, this.warningCollector, this.logicalPlanOptimizers).plan((Analysis)analysis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributedQueryPlan doDistributionPlan(IAnalysis analysis, LogicalQueryPlan logicalPlan, MPPQueryContext context) {
        long startTime = System.nanoTime();
        try {
            TableDistributedPlanner planner = new TableDistributedPlanner((Analysis)analysis, this.symbolAllocator, logicalPlan, this.metadata, this.distributionPlanOptimizers, this.dataNodeLocationSupplier);
            DistributedQueryPlan distributedQueryPlan = planner.plan();
            return distributedQueryPlan;
        }
        finally {
            if (analysis.isQuery()) {
                long distributionPlanCost = System.nanoTime() - startTime;
                context.setDistributionPlanCost(distributionPlanCost);
                QueryPlanCostMetricSet.getInstance().recordTablePlanCost("distribution_planner", distributionPlanCost);
            }
        }
    }

    @Override
    public IScheduler doSchedule(IAnalysis analysis, DistributedQueryPlan distributedPlan, MPPQueryContext context, QueryStateMachine stateMachine) {
        boolean isPipeEnrichedTsFileLoad = this.statement instanceof PipeEnriched && ((PipeEnriched)this.statement).getInnerStatement() instanceof LoadTsFile;
        IScheduler scheduler = this.statement instanceof LoadTsFile || isPipeEnrichedTsFileLoad ? new LoadTsFileScheduler(distributedPlan, context, stateMachine, this.syncInternalServiceClientManager, ClusterPartitionFetcher.getInstance(), isPipeEnrichedTsFileLoad) : new ClusterScheduler(context, stateMachine, distributedPlan.getInstances(), context.getQueryType(), this.scheduledExecutor, this.syncInternalServiceClientManager, this.asyncInternalServiceClientManager);
        scheduler.start();
        return scheduler;
    }

    @Override
    public void invalidatePartitionCache() {
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    @Override
    public void setRedirectInfo(IAnalysis iAnalysis, TEndPoint localEndPoint, TSStatus tsstatus) {
        Statement statementToRedirect;
        Analysis analysis = (Analysis)iAnalysis;
        Statement statement = statementToRedirect = analysis.getStatement() instanceof PipeEnriched ? ((PipeEnriched)analysis.getStatement()).getInnerStatement() : analysis.getStatement();
        if (!(statementToRedirect instanceof WrappedInsertStatement)) {
            return;
        }
        InsertBaseStatement insertStatement = ((WrappedInsertStatement)statementToRedirect).getInnerTreeStatement();
        if (!analysis.isFinishQueryAfterAnalyze() && insertStatement instanceof InsertTabletStatement && tsstatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            boolean needRedirect = false;
            List<TEndPoint> redirectNodeList = analysis.getRedirectNodeList();
            ArrayList<TSStatus> subStatus = new ArrayList<TSStatus>(redirectNodeList.size());
            for (TEndPoint endPoint : redirectNodeList) {
                if (!localEndPoint.equals(endPoint)) {
                    subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS).setRedirectNode(endPoint));
                    needRedirect = true;
                    continue;
                }
                subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            }
            if (needRedirect) {
                tsstatus.setCode(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
                tsstatus.setSubStatus(subStatus);
            }
        }
    }
}

