/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;

public class ConvertPredicateToTimeFilterVisitor
extends PredicateVisitor<Filter, Void> {
    @Override
    protected Filter visitInPredicate(InPredicate node, Void context) {
        Expression valueList = node.getValueList();
        Preconditions.checkArgument((boolean)(valueList instanceof InListExpression));
        List<Expression> values = ((InListExpression)valueList).getValues();
        for (Expression value : values) {
            Preconditions.checkArgument((boolean)(value instanceof LongLiteral));
        }
        if (values.size() == 1) {
            return TimeFilterApi.eq((long)ConvertPredicateToTimeFilterVisitor.getLongValue(values.get(0)));
        }
        HashSet<Long> longValues = new HashSet<Long>();
        for (Expression value : values) {
            longValues.add(((LongLiteral)value).getParsedValue());
        }
        return TimeFilterApi.in(longValues);
    }

    @Override
    protected Filter visitIsNullPredicate(IsNullPredicate node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support IS NULL");
    }

    @Override
    protected Filter visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support IS NOT NULL");
    }

    @Override
    protected Filter visitLikePredicate(LikePredicate node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support LIKE");
    }

    @Override
    protected Filter visitLogicalExpression(LogicalExpression node, Void context) {
        List filterList = node.getTerms().stream().map(n -> n.accept(this, context)).filter(Objects::nonNull).collect(Collectors.toList());
        switch (node.getOperator()) {
            case OR: {
                return FilterFactory.or(filterList);
            }
            case AND: {
                return FilterFactory.and(filterList);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)node.getOperator()));
    }

    @Override
    protected Filter visitNotExpression(NotExpression node, Void context) {
        return FilterFactory.not((Filter)node.getValue().accept(this, context));
    }

    @Override
    protected Filter visitComparisonExpression(ComparisonExpression node, Void context) {
        if (node.getLeft() instanceof LongLiteral) {
            long value = ConvertPredicateToTimeFilterVisitor.getLongValue(node.getLeft());
            switch (node.getOperator()) {
                case EQUAL: {
                    return TimeFilterApi.eq((long)value);
                }
                case NOT_EQUAL: {
                    return TimeFilterApi.notEq((long)value);
                }
                case GREATER_THAN: {
                    return TimeFilterApi.lt((long)value);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return TimeFilterApi.ltEq((long)value);
                }
                case LESS_THAN: {
                    return TimeFilterApi.gt((long)value);
                }
                case LESS_THAN_OR_EQUAL: {
                    return TimeFilterApi.gtEq((long)value);
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)node.getOperator()));
        }
        if (node.getRight() instanceof LongLiteral) {
            long value = ConvertPredicateToTimeFilterVisitor.getLongValue(node.getRight());
            switch (node.getOperator()) {
                case EQUAL: {
                    return TimeFilterApi.eq((long)value);
                }
                case NOT_EQUAL: {
                    return TimeFilterApi.notEq((long)value);
                }
                case GREATER_THAN: {
                    return TimeFilterApi.gt((long)value);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return TimeFilterApi.gtEq((long)value);
                }
                case LESS_THAN: {
                    return TimeFilterApi.lt((long)value);
                }
                case LESS_THAN_OR_EQUAL: {
                    return TimeFilterApi.ltEq((long)value);
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)node.getOperator()));
        }
        throw new IllegalStateException("Either left or right operand of Time ComparisonExpression should be LongLiteral");
    }

    @Override
    protected Filter visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not CASE WHEN");
    }

    @Override
    protected Filter visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not CASE WHEN");
    }

    @Override
    protected Filter visitIfExpression(IfExpression node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not IF");
    }

    @Override
    protected Filter visitNullIfExpression(NullIfExpression node, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not NULLIF");
    }

    @Override
    protected Filter visitBetweenPredicate(BetweenPredicate node, Void context) {
        Expression firstExpression = node.getValue();
        Expression secondExpression = node.getMin();
        Expression thirdExpression = node.getMax();
        if (firstExpression instanceof SymbolReference) {
            long maxValue;
            long minValue = ConvertPredicateToTimeFilterVisitor.getLongValue(secondExpression);
            if (minValue == (maxValue = ConvertPredicateToTimeFilterVisitor.getLongValue(thirdExpression))) {
                return TimeFilterApi.eq((long)minValue);
            }
            return TimeFilterApi.between((long)minValue, (long)maxValue);
        }
        if (secondExpression instanceof SymbolReference) {
            long maxValue;
            long value = ConvertPredicateToTimeFilterVisitor.getLongValue(firstExpression);
            Preconditions.checkArgument((value <= (maxValue = ConvertPredicateToTimeFilterVisitor.getLongValue(thirdExpression)) ? 1 : 0) != 0, (Object)String.format("Predicate [%s] should be simplified in previous step", node));
            return TimeFilterApi.ltEq((long)value);
        }
        if (thirdExpression instanceof SymbolReference) {
            long minValue;
            long value = ConvertPredicateToTimeFilterVisitor.getLongValue(firstExpression);
            Preconditions.checkArgument((value >= (minValue = ConvertPredicateToTimeFilterVisitor.getLongValue(secondExpression)) ? 1 : 0) != 0, (Object)String.format("Predicate [%s] should be simplified in previous step", node));
            return TimeFilterApi.gtEq((long)value);
        }
        throw new IllegalStateException("Three operand of between expression should have time column.");
    }

    public static long getLongValue(Expression expression) {
        return ((LongLiteral)expression).getParsedValue();
    }
}

