/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntryGroupImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;
import org.apache.tsfile.utils.RamUsageEstimator;

class DualKeyCacheImpl<FK, SK, V, T extends ICacheEntry<SK, V>>
implements IDualKeyCache<FK, SK, V> {
    private final SegmentedConcurrentHashMap<FK, ICacheEntryGroup<FK, SK, V, T>> firstKeyMap = new SegmentedConcurrentHashMap();
    private final ICacheEntryManager<FK, SK, V, T> cacheEntryManager;
    private final ICacheSizeComputer<FK, SK, V> sizeComputer;
    private final CacheStats cacheStats;

    DualKeyCacheImpl(ICacheEntryManager<FK, SK, V, T> cacheEntryManager, ICacheSizeComputer<FK, SK, V> sizeComputer, long memoryCapacity) {
        this.cacheEntryManager = cacheEntryManager;
        this.sizeComputer = sizeComputer;
        this.cacheStats = new CacheStats(memoryCapacity, this::getMemory, this::getEntriesCount);
    }

    @Override
    public V get(FK firstKey, SK secondKey) {
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (cacheEntryGroup == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        T cacheEntry = cacheEntryGroup.getCacheEntry(secondKey);
        if (cacheEntry == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        this.cacheEntryManager.access(cacheEntry);
        this.cacheStats.recordHit(1);
        return cacheEntry.getValue();
    }

    @Override
    public void update(FK firstKey, @Nonnull SK secondKey, V value, ToIntFunction<V> updater, boolean createIfNotExists) {
        ICacheEntryGroup cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (Objects.isNull(cacheEntryGroup)) {
            if (createIfNotExists) {
                cacheEntryGroup = new CacheEntryGroupImpl(firstKey, this.sizeComputer);
                this.firstKeyMap.put(firstKey, cacheEntryGroup);
            } else {
                return;
            }
        }
        ICacheEntryGroup finalCacheEntryGroup = cacheEntryGroup;
        cacheEntryGroup.computeCacheEntry(secondKey, memory -> (sk, cacheEntry) -> {
            if (Objects.isNull(cacheEntry)) {
                if (!createIfNotExists) {
                    return null;
                }
                cacheEntry = this.cacheEntryManager.createCacheEntry(secondKey, value, finalCacheEntryGroup);
                this.cacheEntryManager.put(cacheEntry);
                memory.getAndAdd((long)(this.sizeComputer.computeSecondKeySize(sk) + this.sizeComputer.computeValueSize(cacheEntry.getValue())) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
            }
            memory.getAndAdd(updater.applyAsInt(cacheEntry.getValue()));
            return cacheEntry;
        });
        this.mayEvict();
    }

    @Override
    public void update(FK firstKey, Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        ICacheEntryGroup entryGroup = this.firstKeyMap.get(firstKey);
        if (Objects.nonNull(entryGroup)) {
            entryGroup.getAllCacheEntries().forEachRemaining(entry -> {
                if (!secondKeyChecker.test(entry.getKey())) {
                    return;
                }
                entryGroup.computeCacheEntry(entry.getKey(), memory -> (secondKey, cacheEntry) -> {
                    if (Objects.nonNull(cacheEntry)) {
                        memory.getAndAdd(updater.applyAsInt(cacheEntry.getValue()));
                    }
                    return cacheEntry;
                });
            });
        }
        this.mayEvict();
    }

    @Override
    public void update(Predicate<FK> firstKeyChecker, Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        for (FK firstKey : this.firstKeyMap.getAllKeys()) {
            if (!firstKeyChecker.test(firstKey)) continue;
            ICacheEntryGroup entryGroup = this.firstKeyMap.get(firstKey);
            if (Objects.nonNull(entryGroup)) {
                entryGroup.getAllCacheEntries().forEachRemaining(entry -> {
                    if (!secondKeyChecker.test(entry.getKey())) {
                        return;
                    }
                    entryGroup.computeCacheEntry(entry.getKey(), memory -> (secondKey, cacheEntry) -> {
                        memory.getAndAdd(updater.applyAsInt(cacheEntry.getValue()));
                        return cacheEntry;
                    });
                });
            }
            this.mayEvict();
        }
    }

    private void mayEvict() {
        long exceedMemory;
        while ((exceedMemory = this.cacheStats.getExceedMemory()) > 0L) {
            while ((exceedMemory -= this.evictOneCacheEntry()) > 0L && this.firstKeyMap.size() > 100) {
            }
        }
    }

    private long evictOneCacheEntry() {
        T evictCacheEntry = this.cacheEntryManager.evict();
        if (evictCacheEntry == null) {
            return 0L;
        }
        ICacheEntryGroup belongedGroup = evictCacheEntry.getBelongedGroup();
        evictCacheEntry.setBelongedGroup(null);
        long memory = belongedGroup.removeCacheEntry(evictCacheEntry.getSecondKey());
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(belongedGroup.getFirstKey());
        if (Objects.nonNull(cacheEntryGroup) && cacheEntryGroup.isEmpty() && Objects.nonNull(this.firstKeyMap.remove(belongedGroup.getFirstKey()))) {
            memory += (long)this.sizeComputer.computeFirstKeySize(belongedGroup.getFirstKey()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
        }
        return memory;
    }

    @Override
    public void invalidateAll() {
        this.firstKeyMap.clear();
        this.cacheEntryManager.cleanUp();
    }

    @Override
    public IDualKeyCacheStats stats() {
        return this.cacheStats;
    }

    @Override
    public void invalidate(FK firstKey) {
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.remove(firstKey);
        if (cacheEntryGroup != null) {
            Iterator<Map.Entry<SK, T>> it = cacheEntryGroup.getAllCacheEntries();
            while (it.hasNext()) {
                this.cacheEntryManager.invalidate((ICacheEntry)it.next().getValue());
            }
        }
    }

    @Override
    public void invalidate(FK firstKey, SK secondKey) {
        ICacheEntryGroup cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (Objects.isNull(cacheEntryGroup)) {
            return;
        }
        T entry = cacheEntryGroup.getCacheEntry(secondKey);
        if (Objects.nonNull(entry) && this.cacheEntryManager.invalidate(entry)) {
            cacheEntryGroup.removeCacheEntry(entry.getSecondKey());
        }
        if (cacheEntryGroup.isEmpty()) {
            this.firstKeyMap.remove(firstKey);
        }
    }

    @Override
    public void invalidate(FK firstKey, Predicate<SK> secondKeyChecker) {
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (Objects.isNull(cacheEntryGroup)) {
            return;
        }
        Iterator<Map.Entry<SK, T>> it = cacheEntryGroup.getAllCacheEntries();
        while (it.hasNext()) {
            Map.Entry<SK, T> entry = it.next();
            if (!secondKeyChecker.test(entry.getKey()) || !this.cacheEntryManager.invalidate((ICacheEntry)entry.getValue())) continue;
            cacheEntryGroup.removeCacheEntry(entry.getKey());
        }
        if (cacheEntryGroup.isEmpty()) {
            this.firstKeyMap.remove(firstKey);
        }
    }

    @Override
    public void invalidate(Predicate<FK> firstKeyChecker, Predicate<SK> secondKeyChecker) {
        for (FK firstKey : this.firstKeyMap.getAllKeys()) {
            if (!firstKeyChecker.test(firstKey)) continue;
            ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
            if (Objects.isNull(cacheEntryGroup)) {
                return;
            }
            Iterator<Map.Entry<SK, T>> it = cacheEntryGroup.getAllCacheEntries();
            while (it.hasNext()) {
                Map.Entry<SK, T> entry = it.next();
                if (!secondKeyChecker.test(entry.getKey()) || !this.cacheEntryManager.invalidate((ICacheEntry)entry.getValue())) continue;
                cacheEntryGroup.removeCacheEntry(entry.getKey());
            }
            if (!cacheEntryGroup.isEmpty()) continue;
            this.firstKeyMap.remove(firstKey);
        }
    }

    private long getMemory() {
        long memory = 0L;
        for (Map map : ((SegmentedConcurrentHashMap)this.firstKeyMap).maps) {
            if (!Objects.nonNull(map)) continue;
            for (ICacheEntryGroup group : map.values()) {
                memory += group.getMemory();
            }
        }
        return memory;
    }

    private long getEntriesCount() {
        long count = 0L;
        for (Map map : ((SegmentedConcurrentHashMap)this.firstKeyMap).maps) {
            if (!Objects.nonNull(map)) continue;
            for (ICacheEntryGroup group : map.values()) {
                count += (long)group.getEntriesCount();
            }
        }
        return count;
    }

    private static class SegmentedConcurrentHashMap<K, V> {
        private static final int SLOT_NUM = 31;
        private final Map<K, V>[] maps = new ConcurrentHashMap[31];

        private SegmentedConcurrentHashMap() {
        }

        V get(K key) {
            return this.getBelongedMap(key).get(key);
        }

        V remove(K key) {
            return this.getBelongedMap(key).remove(key);
        }

        V put(K key, V value) {
            return this.getBelongedMap(key).put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                Arrays.fill(this.maps, null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Map<K, V> getBelongedMap(K key) {
            int slotIndex = key.hashCode() % 31;
            slotIndex = slotIndex < 0 ? slotIndex + 31 : slotIndex;
            Map<K, V> map = this.maps[slotIndex];
            if (map != null) return map;
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                map = this.maps[slotIndex];
                if (map != null) return map;
                this.maps[slotIndex] = map = new ConcurrentHashMap();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return map;
            }
        }

        List<K> getAllKeys() {
            ArrayList res = new ArrayList();
            Arrays.stream(this.maps).iterator().forEachRemaining(map -> {
                if (map != null) {
                    res.addAll(map.keySet());
                }
            });
            return res;
        }

        int size() {
            int size = 0;
            for (Map<K, V> map : this.maps) {
                if (!Objects.nonNull(map)) continue;
                size += map.size();
            }
            return size;
        }
    }
}

