/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResourceManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.service.DataNode;
import org.apache.iotdb.db.service.ExternalRPCService;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.rescon.disk.DirectoryChecker;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeShutdownHook.class);
    private final TDataNodeLocation nodeLocation;

    public DataNodeShutdownHook(TDataNodeLocation nodeLocation) {
        super(ThreadName.DATANODE_SHUTDOWN_HOOK.getName());
        this.nodeLocation = nodeLocation;
    }

    @Override
    public void run() {
        logger.info("DataNode exiting...");
        ExternalRPCService.getInstance().stop();
        CommonDescriptor.getInstance().getConfig().setStopping(true);
        CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
        WALManager.getInstance().waitAllWALFlushed();
        DeletionResourceManager.exit();
        if (!IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        }
        WALManager.getInstance().syncDeleteOutdatedFilesInWALNodes();
        if (IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            this.triggerSnapshotForAllDataRegion();
        }
        PipeSubtaskExecutorManager.getInstance().shutdownAll();
        DataNode.getInstance().stop();
        if (!this.reportShutdownToConfigNodeLeader()) {
            logger.warn("Failed to report DataNode's shutdown to ConfigNode. The cluster will still take the current DataNode as Running for a few seconds.");
        }
        DirectoryChecker.getInstance().deregisterAll();
        logger.info("DataNode exits. Jvm memory usage: {}", (Object)MemUtils.bytesCntToStr(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
    }

    private void triggerSnapshotForAllDataRegion() {
        DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().parallelStream().forEach(id -> {
            try {
                DataRegionConsensusImpl.getInstance().triggerSnapshot(id, false);
            }
            catch (ConsensusException e) {
                logger.warn("Something wrong happened while calling consensus layer's triggerSnapshot API.", (Throwable)e);
            }
        });
    }

    private boolean reportShutdownToConfigNodeLeader() {
        ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            boolean bl;
            boolean bl2 = bl = client.reportDataNodeShutdown(this.nodeLocation).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
            if (client != null) {
                client.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException e) {
                logger.error("Failed to borrow ConfigNodeClient", (Throwable)e);
            }
            catch (TException e) {
                logger.error("Failed to report shutdown", (Throwable)e);
            }
        }
        return false;
    }
}

