/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GroupNode
extends SortNode {
    private int partitionKeyCount;

    public GroupNode(PlanNodeId id, PlanNode child, OrderingScheme scheme, int partitionKeyCount) {
        super(id, child, scheme, false, false);
        this.partitionKeyCount = partitionKeyCount;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new GroupNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme, this.partitionKeyCount);
    }

    public int getPartitionKeyCount() {
        return this.partitionKeyCount;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroup(this, context);
    }

    @Override
    public PlanNode clone() {
        return new GroupNode(this.id, null, this.orderingScheme, this.partitionKeyCount);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_GROUP_NODE.serialize(byteBuffer);
        this.orderingScheme.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.partitionKeyCount, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_GROUP_NODE.serialize(stream);
        this.orderingScheme.serialize(stream);
        ReadWriteIOUtils.write((int)this.partitionKeyCount, (OutputStream)stream);
    }

    public static GroupNode deserialize(ByteBuffer byteBuffer) {
        OrderingScheme orderingScheme = OrderingScheme.deserialize(byteBuffer);
        int partitionColumnCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new GroupNode(planNodeId, null, orderingScheme, partitionColumnCount);
    }

    @Override
    public String toString() {
        return "GroupNode-" + this.getPlanNodeId();
    }
}

