/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;

public class PruneTableFunctionProcessorColumns
extends ProjectOffPushDownRule<TableFunctionProcessorNode> {
    public PruneTableFunctionProcessorColumns() {
        super(Patterns.tableFunctionProcessor());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TableFunctionProcessorNode node, Set<Symbol> referencedOutputs) {
        int prunedPassThroughCount;
        Optional<TableFunctionNode.PassThroughSpecification> prunedPassThroughSpecifications = node.getPassThroughSpecification().map(sourceSpecification -> {
            List prunedPassThroughColumns = (List)sourceSpecification.getColumns().stream().filter(column -> referencedOutputs.contains(column.getSymbol())).collect(ImmutableList.toImmutableList());
            return new TableFunctionNode.PassThroughSpecification(sourceSpecification.isDeclaredAsPassThrough(), prunedPassThroughColumns);
        });
        if (!prunedPassThroughSpecifications.isPresent()) {
            return Optional.empty();
        }
        int originalPassThroughCount = node.getPassThroughSpecification().get().getColumns().size();
        if (originalPassThroughCount == (prunedPassThroughCount = prunedPassThroughSpecifications.get().getColumns().size())) {
            return Optional.empty();
        }
        return Optional.of(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.ofNullable(node.getChild()), prunedPassThroughSpecifications, node.getRequiredSymbols(), node.getDataOrganizationSpecification(), node.isRowSemantic(), node.getArguments(), node.isRequireRecordSnapshot()));
    }
}

