/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractSeriesScanOperator
extends AbstractDataSourceOperator {
    private boolean finished = false;

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (this.resultTsBlockBuilder.isEmpty()) {
            return null;
        }
        this.resultTsBlock = this.resultTsBlockBuilder.build();
        this.resultTsBlockBuilder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            boolean noMoreData = false;
            do {
                if (this.readPageData() || this.readChunkData() || this.readFileData()) continue;
                noMoreData = true;
                break;
            } while (System.nanoTime() - start < maxRuntime && !this.resultTsBlockBuilder.isFull() && this.retainedTsBlock == null);
            this.finished = this.resultTsBlockBuilder.isEmpty() && this.retainedTsBlock == null && noMoreData;
            return !this.finished;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    protected boolean readFileData() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            return true;
        }
        return false;
    }

    protected boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    protected boolean readPageData() throws IOException {
        if (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock = this.seriesScanUtil.nextPage();
            if (!this.isEmpty(tsBlock)) {
                this.appendToBuilder(tsBlock);
            }
            return true;
        }
        return false;
    }

    protected boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    protected void appendToBuilder(TsBlock tsBlock) {
        int size = tsBlock.getPositionCount();
        if (this.resultTsBlockBuilder.isEmpty() && size >= this.resultTsBlockBuilder.getMaxTsBlockLineNumber()) {
            this.retainedTsBlock = tsBlock;
            return;
        }
        this.buildResult(tsBlock);
    }

    protected abstract void buildResult(TsBlock var1);

    @Override
    protected List<TSDataType> getResultDataTypes() {
        return this.seriesScanUtil.getTsDataTypeList();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.calculateMaxPeekMemoryWithCounter() - this.calculateMaxReturnSize();
    }
}

