/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.airgap;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBAirGapConnector;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.connector.protocol.airgap.IoTDBDataNodeAirGapConnector;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class IoTDBSchemaRegionAirGapConnector
extends IoTDBDataNodeAirGapConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSchemaRegionAirGapConnector.class);

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionAirGapConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionAirGapConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapConnector.AirGapSocket socket = (IoTDBAirGapConnector.AirGapSocket)this.sockets.get(socketIndex);
        try {
            if (event instanceof PipeSchemaRegionWritePlanEvent) {
                this.doTransferWrapper(socket, (PipeSchemaRegionWritePlanEvent)event);
            } else if (event instanceof PipeSchemaRegionSnapshotEvent) {
                this.doTransferWrapper(socket, (PipeSchemaRegionSnapshotEvent)event);
            } else if (!(event instanceof PipeHeartbeatEvent)) {
                LOGGER.warn("IoTDBSchemaRegionAirGapConnector does not support transferring generic event: {}.", (Object)event);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer event %s, because %s.", ((EnrichedEvent)event).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    private void doTransferWrapper(IoTDBAirGapConnector.AirGapSocket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeAirGapConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeAirGapConnector.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapConnector.AirGapSocket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        if (!this.send(pipeSchemaRegionWritePlanEvent.getPipeName(), pipeSchemaRegionWritePlanEvent.getCreationTime(), socket, PipeTransferPlanNodeReq.toTPipeTransferBytes(pipeSchemaRegionWritePlanEvent.getPlanNode()))) {
            String errorMessage = String.format("Transfer data node write plan %s error. Socket: %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), socket});
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeSchemaRegionWritePlanEvent.toString());
        }
    }

    private void doTransferWrapper(IoTDBAirGapConnector.AirGapSocket socket, PipeSchemaRegionSnapshotEvent pipeSchemaRegionSnapshotEvent) throws PipeException, IOException {
        if (!pipeSchemaRegionSnapshotEvent.increaseReferenceCount(IoTDBSchemaRegionAirGapConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeSchemaRegionSnapshotEvent);
        }
        finally {
            pipeSchemaRegionSnapshotEvent.decreaseReferenceCount(IoTDBSchemaRegionAirGapConnector.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapConnector.AirGapSocket socket, PipeSchemaRegionSnapshotEvent pipeSchemaRegionSnapshotEvent) throws PipeException, IOException {
        String pipeName = pipeSchemaRegionSnapshotEvent.getPipeName();
        long creationTime = pipeSchemaRegionSnapshotEvent.getCreationTime();
        File mtreeSnapshotFile = pipeSchemaRegionSnapshotEvent.getMTreeSnapshotFile();
        File tagLogSnapshotFile = pipeSchemaRegionSnapshotEvent.getTagLogSnapshotFile();
        File attributeSnapshotFile = pipeSchemaRegionSnapshotEvent.getAttributeSnapshotFile();
        this.transferFilePieces(pipeName, creationTime, mtreeSnapshotFile, socket, true);
        if (Objects.nonNull(tagLogSnapshotFile)) {
            this.transferFilePieces(pipeName, creationTime, tagLogSnapshotFile, socket, true);
        }
        if (Objects.nonNull(attributeSnapshotFile)) {
            this.transferFilePieces(pipeName, creationTime, attributeSnapshotFile, socket, true);
        }
        if (!this.send(pipeName, creationTime, socket, PipeTransferSchemaSnapshotSealReq.toTPipeTransferBytes(pipeSchemaRegionSnapshotEvent.getTreePatternString(), pipeSchemaRegionSnapshotEvent.getTablePattern().getDatabasePattern(), pipeSchemaRegionSnapshotEvent.getTablePattern().getTablePattern(), pipeSchemaRegionSnapshotEvent.getTreePattern().isTreeModelDataAllowedToBeCaptured(), pipeSchemaRegionSnapshotEvent.getTablePattern().isTableModelDataAllowedToBeCaptured(), mtreeSnapshotFile.getName(), mtreeSnapshotFile.length(), Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.getName() : null, Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.length() : 0L, Objects.nonNull(attributeSnapshotFile) ? attributeSnapshotFile.getName() : null, Objects.nonNull(attributeSnapshotFile) ? attributeSnapshotFile.length() : 0L, pipeSchemaRegionSnapshotEvent.getDatabaseName(), pipeSchemaRegionSnapshotEvent.toSealTypeString()))) {
            String errorMessage = String.format("Seal schema region snapshot file %s and %s error. Socket %s.", mtreeSnapshotFile, tagLogSnapshotFile, socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeSchemaRegionSnapshotEvent.toString());
        } else {
            LOGGER.info("Successfully transferred schema region snapshot {}, {} and {}.", new Object[]{mtreeSnapshotFile, tagLogSnapshotFile, attributeSnapshotFile});
        }
    }

    protected byte[] getTransferSingleFilePieceBytes(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The schema region air gap connector does not support transferring single file piece bytes.");
    }

    protected byte[] getTransferMultiFilePieceBytes(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferSchemaSnapshotPieceReq.toTPipeTransferBytes(fileName, position, payLoad);
    }
}

