/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractInnerCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class ReadPointInnerCompactionWriter
extends AbstractInnerCompactionWriter {
    public ReadPointInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        super(targetFileResource);
    }

    public ReadPointInnerCompactionWriter(List<TsFileResource> targetFileResources) throws IOException {
        super(targetFileResources);
    }

    @Override
    public void write(TsBlock tsBlock, int subTaskId) throws IOException {
        TimeColumn timestamps = (TimeColumn)tsBlock.getTimeColumn();
        Column[] columns = tsBlock.getValueColumns();
        int batchSize = tsBlock.getPositionCount();
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + timestamps.getTimes().length;
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, (IChunkWriter)chunkWriter, subTaskId);
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushAlignedChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushBatchedValueChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId, AbstractCompactionFlushController flushController) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushAlignedPage(AlignedPageElement alignedPageElement, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushBatchedValuePage(AlignedPageElement alignedPageElement, int subTaskId, AbstractCompactionFlushController flushController) throws PageException, IOException {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }
}

