/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.DateUtils;

public class DateSubtractionLongColumnTransformer
extends BinaryColumnTransformer {
    private static ZoneId zoneId;

    public DateSubtractionLongColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer, ZoneId zoneId) {
        super(returnType, leftTransformer, rightTransformer);
        DateSubtractionLongColumnTransformer.zoneId = zoneId;
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeInt(builder, DateSubtractionLongColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getLong(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i) && selection[i]) {
                this.returnType.writeInt(builder, DateSubtractionLongColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getLong(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static int transform(int left, long right) {
        try {
            long timestamp = Math.subtractExact(DateTimeUtils.correctPrecision(DateUtils.parseIntToTimestamp((int)left, (ZoneId)zoneId)), right);
            return DateUtils.parseDateExpressionToInt((LocalDate)DateTimeUtils.convertToLocalDate(timestamp, zoneId));
        }
        catch (ArithmeticException e) {
            throw new IoTDBRuntimeException(String.format("long Subtraction overflow: %s - %s", left, right), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
        catch (DateTimeParseException e) {
            throw new IoTDBRuntimeException("Year must be between 1000 and 9999.", TSStatusCode.DATE_OUT_OF_RANGE.getStatusCode(), true);
        }
    }
}

