/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SingleColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite.StatementRewrite;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.QueryUtil;

public final class ShowRewrite
implements StatementRewrite.Rewrite {
    private final Metadata metadata;
    private final AccessControl accessControl;

    public ShowRewrite(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public Statement rewrite(StatementAnalyzerFactory analyzerFactory, SessionInfo session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        Visitor visitor = new Visitor(this.metadata, session, this.accessControl);
        return (Statement)visitor.process(node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final SessionInfo session;
        private final AccessControl accessControl;

        public Visitor(Metadata metadata, SessionInfo session, AccessControl accessControl) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        }

        @Override
        protected Node visitShowQueriesStatement(ShowQueriesStatement node, Void context) {
            this.accessControl.checkUserIsAdmin(this.session.getUserName());
            return this.visitShowStatement((ShowStatement)node, context);
        }

        @Override
        protected Node visitShowStatement(ShowStatement showStatement, Void context) {
            return QueryUtil.simpleQuery(QueryUtil.selectList(new AllColumns()), Visitor.from("information_schema", showStatement.getTableName()), showStatement.getWhere(), Optional.empty(), Optional.empty(), Optional.empty(), showStatement.getOrderBy(), showStatement.getOffset(), showStatement.getLimit());
        }

        @Override
        protected Node visitCountStatement(CountStatement countStatement, Void context) {
            return QueryUtil.simpleQuery(new Select(false, Collections.singletonList(new SingleColumn(new FunctionCall(QualifiedName.of(Collections.singletonList(new Identifier("count"))), Collections.emptyList()), new Identifier("count(devices)")))), Visitor.from("information_schema", countStatement.getTableName()), countStatement.getWhere(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        private static Relation from(String db, String table) {
            return QueryUtil.table(QualifiedName.of(db, table));
        }

        @Override
        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

