/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LikePredicate
extends Expression {
    private final Expression value;
    private final Expression pattern;
    @Nullable
    private final Expression escape;

    public LikePredicate(Expression value, Expression pattern, Expression escape) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = escape;
    }

    public LikePredicate(NodeLocation location, Expression value, Expression pattern) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = null;
    }

    public LikePredicate(Expression value, Expression pattern) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = null;
    }

    public LikePredicate(NodeLocation location, Expression value, Expression pattern, Expression escape) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public LikePredicate(ByteBuffer byteBuffer) {
        super(null);
        this.value = Expression.deserialize(byteBuffer);
        this.pattern = Expression.deserialize(byteBuffer);
        boolean hasEscape = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.escape = hasEscape ? Expression.deserialize(byteBuffer) : null;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.LIKE_PREDICATE;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.value, stream);
        Expression.serialize(this.pattern, stream);
        ReadWriteIOUtils.write((Boolean)(this.escape != null ? 1 : 0), (OutputStream)stream);
        if (this.escape != null) {
            Expression.serialize(this.escape, stream);
        }
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    public Optional<Expression> getEscape() {
        return Optional.ofNullable(this.escape);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLikePredicate(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder result = ImmutableList.builder().add((Object)this.value).add((Object)this.pattern);
        if (this.escape != null) {
            result.add((Object)this.escape);
        }
        return result.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.escape, that.escape);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.pattern, this.escape);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return LikePredicate.sameClass(this, other);
    }
}

