/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CorrelationSupport;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionId;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionKind;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.FunctionNullability;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.OperatorNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentTime;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DecimalLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StackableAstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.RowType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.UnknownType;

public class ExpressionAnalyzer {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory;
    private final TypeProvider symbolTypes;
    private final Map<NodeRef<Node>, ResolvedFunction> resolvedFunctions = new LinkedHashMap<NodeRef<Node>, ResolvedFunction>();
    private final Set<NodeRef<SubqueryExpression>> subqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, Analysis.PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, Analysis.PredicateCoercions>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Multimap<NodeRef<Node>, Field> referencedFields = HashMultimap.create();
    private final MPPQueryContext context;
    private final SessionInfo session;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final WarningCollector warningCollector;
    private final Function<Expression, Type> getPreanalyzedType;
    private final List<Field> sourceFields = new ArrayList<Field>();
    private final Map<NodeRef<DereferenceExpression>, LabelPrefixedReference> labelDereferences = new LinkedHashMap<NodeRef<DereferenceExpression>, LabelPrefixedReference>();
    private static final String SUBQUERY_COLUMN_NUM_CHECK = "Subquery must return only one column for now. Row Type is not supported for now.";

    private ExpressionAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, SessionInfo session, TypeProvider types, WarningCollector warningCollector) {
        this(metadata, context, accessControl, (node, correlationSupport) -> statementAnalyzerFactory.createStatementAnalyzer(analysis, context, session, warningCollector, (CorrelationSupport)((Object)correlationSupport)), session, types, analysis.getParameters(), warningCollector, analysis::getType);
    }

    ExpressionAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory, SessionInfo session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, Function<Expression, Type> getPreanalyzedType) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.getPreanalyzedType = Objects.requireNonNull(getPreanalyzedType, "getPreanalyzedType is null");
    }

    public Map<NodeRef<Node>, ResolvedFunction> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put(NodeRef.of(expression), type);
        return type;
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of(expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, Analysis.PredicateCoercions> getPredicateCoercions() {
        return Collections.unmodifiableMap(this.predicateCoercions);
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.notInLambda(scope, CorrelationSupport.ALLOWED)));
    }

    public Type analyze(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.notInLambda(scope, correlationSupport)));
    }

    private Type analyze(Expression expression, Scope scope, Set<String> labels) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.patternRecognition(scope, labels)));
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(context));
    }

    public Set<NodeRef<SubqueryExpression>> getSubqueries() {
        return Collections.unmodifiableSet(this.subqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public List<Field> getSourceFields() {
        return this.sourceFields;
    }

    public static ExpressionAnalysis analyzeExpressions(Metadata metadata, MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, TypeProvider types, Iterable<Expression> expressions, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = new Analysis(null, parameters);
        analysis.setDatabaseName(session.getDatabaseName().get());
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, statementAnalyzerFactory, analysis, session, types, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons());
    }

    public static ExpressionAnalysis analyzeExpression(Metadata metadata, MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons());
    }

    public static void analyzeExpressionWithoutSubqueries(Metadata metadata, MPPQueryContext context, SessionInfo session, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, String message, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, (node, ignored) -> {
            throw new SemanticException(message);
        }, session, TypeProvider.empty(), analysis.getParameters(), warningCollector, analysis::getType);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
    }

    private static void updateAnalysis(Analysis analysis, ExpressionAnalyzer analyzer, SessionInfo session, AccessControl accessControl) {
        analysis.addTypes(analyzer.getExpressionTypes());
        analyzer.getResolvedFunctions().forEach((key, value) -> analysis.addResolvedFunction((Node)key.getNode(), (ResolvedFunction)value, session.getUserName()));
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        analysis.addPredicateCoercions(analyzer.getPredicateCoercions());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, context, accessControl, session, parameters, "Constant expression cannot contain a subquery", warningCollector);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, Map<NodeRef<Parameter>, Expression> parameters, String message, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, context, accessControl, session, TypeProvider.empty(), parameters, node -> new SemanticException(message), warningCollector);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, Function<Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector) {
        return new ExpressionAnalyzer(metadata, context, accessControl, (node, correlationSupport) -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, symbolTypes, parameters, warningCollector, expression -> {
            throw new IllegalStateException("Cannot access preanalyzed types");
        });
    }

    private static boolean isExactNumericWithScaleZero(Type type) {
        return type.equals(IntType.INT32) || type.equals(LongType.INT64);
    }

    private class Visitor
    extends StackableAstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        @Override
        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            if (node instanceof Expression && (type = (Type)ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Expression)node))) != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        @Override
        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)type);
        }

        @Override
        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (Objects.requireNonNull(node.getFunction()) == CurrentTime.Function.TIMESTAMP) {
                return ExpressionAnalyzer.this.setExpressionType(node, (Type)LongType.INT64);
            }
            throw new UnsupportedOperationException(node.toString());
        }

        @Override
        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = ExpressionAnalyzer.this.symbolTypes.getTableModelType(Symbol.from(node));
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitIdentifier(Identifier node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField resolvedField = context.getContext().getScope().resolveField(node, QualifiedName.of(node.getValue()));
            return this.handleResolvedField(node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (!resolvedField.isLocal() && context.getContext().getCorrelationSupport() != CorrelationSupport.ALLOWED) {
                throw new SemanticException(String.format("Reference to column '%s' from outer scope not allowed in this context", node));
            }
            FieldId fieldId = FieldId.from(resolvedField);
            Field field = resolvedField.getField();
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            ExpressionAnalyzer.this.sourceFields.add(field);
            fieldId.getRelationId().getSourceNode().ifPresent(source -> ExpressionAnalyzer.this.referencedFields.put(NodeRef.of(source), (Object)field));
            ResolvedField previous = ExpressionAnalyzer.this.columnReferences.put(NodeRef.of(node), resolvedField);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        @Override
        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType;
            if (DereferenceExpression.isQualifiedAllFieldsReference(node)) {
                throw new SemanticException("<identifier>.* not allowed in this context");
            }
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName(node);
            if (qualifiedName != null) {
                Scope scope = context.getContext().getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField(node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField(node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    TableMetadataImpl.throwColumnNotExistsException(qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw new SemanticException(String.format("Expression %s is not of type ROW", node.getBase()));
            }
            RowType rowType = (RowType)baseType;
            Identifier field = node.getField().orElseThrow(() -> new NoSuchElementException("No value present"));
            String fieldName = field.getValue();
            boolean foundFieldName = false;
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                if (foundFieldName) {
                    throw new SemanticException(String.format("Ambiguous row field reference: %s", fieldName));
                }
                foundFieldName = true;
                rowFieldType = rowField.getType();
            }
            if (rowFieldType == null) {
                TableMetadataImpl.throwColumnNotExistsException(qualifiedName);
            }
            return ExpressionAnalyzer.this.setExpressionType(node, rowFieldType);
        }

        @Override
        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitLogicalExpression(LogicalExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (Expression term : node.getTerms()) {
                this.coerceType(context, term, (Type)BooleanType.BOOLEAN, "Logical expression term");
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OperatorType operatorType = null;
            switch (node.getOperator()) {
                case EQUAL: 
                case NOT_EQUAL: {
                    operatorType = OperatorType.EQUAL;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN: {
                    operatorType = OperatorType.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                    break;
                }
                case IS_DISTINCT_FROM: {
                    operatorType = OperatorType.IS_DISTINCT_FROM;
                }
            }
            return this.getOperator(context, node, operatorType, node.getLeft(), node.getRight());
        }

        @Override
        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (!firstType.equals(secondType = this.process((Node)node.getSecond(), context))) {
                throw new SemanticException(String.format("Types are not comparable with NULLIF: %s vs %s", firstType, secondType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, firstType);
        }

        @Override
        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, node, "Result types for IF must be the same", node.getTrueValue(), node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType(whenClause, whenClauseType);
            }
            return type;
        }

        @Override
        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceCaseOperandToToSingleType(node, context);
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType(whenClause, whenClauseType);
            }
            return type;
        }

        private void coerceCaseOperandToToSingleType(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type operandType = this.process((Node)node.getOperand(), context);
            List<WhenClause> whenClauses = node.getWhenClauses();
            ArrayList<Type> whenOperandTypes = new ArrayList<Type>(whenClauses.size());
            for (WhenClause whenClause : whenClauses) {
                Expression whenOperand = whenClause.getOperand();
                Type whenOperandType = this.process((Node)whenOperand, context);
                whenOperandTypes.add(whenOperandType);
                if (operandType.equals(whenOperandType)) continue;
                throw new SemanticException(String.format("CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
            for (int i = 0; i < whenOperandTypes.size(); ++i) {
                Type whenOperandType = (Type)whenOperandTypes.get(i);
                if (whenOperandType.equals(operandType)) continue;
                throw new SemanticException(String.format("CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        @Override
        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!TableMetadataImpl.isNumericType(type)) {
                        throw new SemanticException(String.format("Unary '+' operator cannot by applied to %s type", type));
                    }
                    return ExpressionAnalyzer.this.setExpressionType(node, type);
                }
                case MINUS: {
                    return this.getOperator(context, node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new IllegalArgumentException("Unknown sign: " + (Object)((Object)node.getSign()));
        }

        @Override
        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, node, OperatorType.valueOf(node.getOperator().name()), node.getLeft(), node.getRight());
        }

        @Override
        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression escape;
            Type escapeType;
            Type valueType = this.process((Node)node.getValue(), context);
            if (!TableMetadataImpl.isCharType(valueType)) {
                throw new SemanticException(String.format("Left side of LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", valueType));
            }
            Type patternType = this.process((Node)node.getPattern(), context);
            if (!TableMetadataImpl.isCharType(patternType)) {
                throw new SemanticException(String.format("Pattern for LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", patternType));
            }
            if (node.getEscape().isPresent() && !TableMetadataImpl.isCharType(escapeType = this.process((Node)(escape = node.getEscape().get()), context))) {
                throw new SemanticException(String.format("Escape for LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", escapeType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BlobType.BLOB);
        }

        @Override
        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getParsedValue() >= Integer.MIN_VALUE && node.getParsedValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType(node, (Type)IntType.INT32);
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)LongType.INT64);
        }

        @Override
        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)DoubleType.DOUBLE);
        }

        @Override
        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException("DecimalLiteral is not supported yet.");
        }

        @Override
        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException("GenericLiteral is not supported yet.");
        }

        @Override
        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)UnknownType.UNKNOWN);
        }

        @Override
        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            String functionName = node.getName().getSuffix();
            boolean isAggregation = ExpressionAnalyzer.this.metadata.isAggregationFunction(ExpressionAnalyzer.this.session, functionName, ExpressionAnalyzer.this.accessControl);
            node.getArguments().stream().filter(DereferenceExpression::isQualifiedAllFieldsReference).findAny().ifPresent(allRowsReference -> {
                if (node.getArguments().size() > 1) {
                    throw new SemanticException("label.* syntax is only supported as the only argument of row pattern count function");
                }
            });
            if (node.isDistinct() && !isAggregation) {
                throw new SemanticException("DISTINCT is not supported for non-aggregation functions");
            }
            List<Type> argumentTypes = this.getCallArgumentTypes(node.getArguments(), context);
            if (node.getArguments().size() > 127) {
                throw new SemanticException(String.format("Too many arguments for function call %s()", functionName));
            }
            for (Type argumentType : argumentTypes) {
                if (!node.isDistinct() || argumentType.isComparable()) continue;
                throw new SemanticException(String.format("DISTINCT can only be applied to comparable types (actual: %s)", argumentType));
            }
            Type type = ExpressionAnalyzer.this.metadata.getFunctionReturnType(functionName, argumentTypes);
            ResolvedFunction resolvedFunction = new ResolvedFunction(new BoundSignature(functionName.toLowerCase(Locale.ENGLISH), type, argumentTypes), new FunctionId("noop"), isAggregation ? FunctionKind.AGGREGATE : FunctionKind.SCALAR, true, isAggregation ? FunctionNullability.getAggregationFunctionNullability(argumentTypes.size()) : FunctionNullability.getScalarFunctionNullability(argumentTypes.size()));
            ExpressionAnalyzer.this.resolvedFunctions.put(NodeRef.of(node), resolvedFunction);
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        public List<Type> getCallArgumentTypes(List<Expression> arguments, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression argument : arguments) {
                if (DereferenceExpression.isQualifiedAllFieldsReference(argument)) {
                    DereferenceExpression allRowsDereference = (DereferenceExpression)argument;
                    String label = this.label((Identifier)allRowsDereference.getBase());
                    if (!context.getContext().getLabels().contains(label)) {
                        throw new SemanticException(String.format("%s is not a primary pattern variable or subset name", label));
                    }
                    ExpressionAnalyzer.this.labelDereferences.put(NodeRef.of(allRowsDereference), new LabelPrefixedReference(label));
                    continue;
                }
                argumentTypesBuilder.add((Object)this.process((Node)argument, context));
            }
            return argumentTypesBuilder.build();
        }

        private String label(Identifier identifier) {
            return identifier.getCanonicalValue();
        }

        @Override
        protected Type visitCurrentDatabase(CurrentDatabase node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitCurrentUser(CurrentUser node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitTrim(Trim node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            argumentTypes.add((Object)this.process((Node)node.getTrimSource(), context));
            node.getTrimCharacter().ifPresent(trimChar -> argumentTypes.add((Object)this.process((Node)trimChar, context)));
            ImmutableList actualTypes = argumentTypes.build();
            String functionName = node.getSpecification().getFunctionName();
            Type returnType = ExpressionAnalyzer.this.metadata.getFunctionReturnType(functionName, (List<? extends Type>)actualTypes);
            return ExpressionAnalyzer.this.setExpressionType(node, returnType);
        }

        @Override
        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (ExpressionAnalyzer.this.parameters.isEmpty()) {
                throw new SemanticException("Query takes no parameters");
            }
            if (node.getId() >= ExpressionAnalyzer.this.parameters.size()) {
                throw new SemanticException(String.format("Invalid parameter index %s, max value is %s", node.getId(), ExpressionAnalyzer.this.parameters.size() - 1));
            }
            Expression providedValue = (Expression)ExpressionAnalyzer.this.parameters.get(NodeRef.of(node));
            if (providedValue == null) {
                throw new SemanticException("No value provided for parameter");
            }
            Type resultType = this.process((Node)providedValue, context);
            return ExpressionAnalyzer.this.setExpressionType(node, resultType);
        }

        @Override
        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            Type minType = this.process((Node)node.getMin(), context);
            Type maxType = this.process((Node)node.getMax(), context);
            if (!TableMetadataImpl.isTwoTypeComparable(Arrays.asList(valueType, minType)) || !TableMetadataImpl.isTwoTypeComparable(Arrays.asList(valueType, maxType))) {
                throw new SemanticException(String.format("Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType));
            }
            if (!valueType.isOrderable()) {
                throw new SemanticException(String.format("Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.metadata.getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            }
            catch (TypeNotFoundException e) {
                throw new SemanticException(String.format("Unknown type: %s", node.getType()));
            }
            if (type.equals(UnknownType.UNKNOWN)) {
                throw new SemanticException("UNKNOWN is not a valid type");
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!(value.equals(UnknownType.UNKNOWN) || node.isTypeOnly() || ExpressionAnalyzer.this.metadata.canCoerce(value, type))) {
                throw new SemanticException(String.format("Cannot cast %s to %s", value, type));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            if (value instanceof Row) {
                throw new SemanticException(ExpressionAnalyzer.SUBQUERY_COLUMN_NUM_CHECK);
            }
            Expression valueList = node.getValueList();
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                Type type = this.coerceToSingleType(context, "IN value and list items", (List<Expression>)ImmutableList.builder().add((Object)value).addAll(inListExpression.getValues()).build());
                ExpressionAnalyzer.this.setExpressionType(inListExpression, type);
            } else if (valueList instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add(NodeRef.of(node));
                this.analyzePredicateWithSubquery(node, this.process((Node)value, context), (SubqueryExpression)valueList, context);
            } else {
                throw new IllegalArgumentException("Unexpected value list type for InPredicate: " + node.getValueList().getClass().getName());
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.analyzeSubquery(node, context);
            if (type instanceof RowType && ((RowType)type).getFields().size() == 1) {
                type = (Type)type.getTypeParameters().get(0);
            }
            ExpressionAnalyzer.this.setExpressionType(node, type);
            ExpressionAnalyzer.this.subqueries.add(NodeRef.of(node));
            return type;
        }

        private Type analyzePredicateWithSubquery(Expression node, Type declaredValueType, SubqueryExpression subquery, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueRowType = declaredValueType;
            Type subqueryType = this.analyzeSubquery(subquery, context);
            ExpressionAnalyzer.this.setExpressionType(subquery, subqueryType);
            Optional<Type> valueCoercion = Optional.empty();
            Optional<Type> subQueryCoercion = Optional.empty();
            ExpressionAnalyzer.this.predicateCoercions.put(NodeRef.of(node), new Analysis.PredicateCoercions(valueRowType, valueCoercion, subQueryCoercion));
            return subqueryType;
        }

        private Type analyzeSubquery(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node, context.getContext().getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getContext().getScope()).build();
            Scope queryScope = analyzer.analyze(node.getQuery(), subqueryScope);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < queryScope.getRelationType().getAllFieldCount(); ++i) {
                Field field = queryScope.getRelationType().getFieldByIndex(i);
                if (field.isHidden()) continue;
                if (field.getName().isPresent()) {
                    fields.add((Object)RowType.field((String)field.getName().get(), (Type)field.getType()));
                    continue;
                }
                fields.add((Object)RowType.field((Type)field.getType()));
            }
            ImmutableList fieldList = fields.build();
            if (fieldList.size() != 1 || ((RowType.Field)fieldList.get(0)).getType() instanceof RowType) {
                throw new SemanticException(ExpressionAnalyzer.SUBQUERY_COLUMN_NUM_CHECK);
            }
            ExpressionAnalyzer.this.sourceFields.addAll(queryScope.getRelationType().getVisibleFields());
            return ((RowType.Field)Iterators.getOnlyElement(fields.build().stream().iterator())).getType();
        }

        @Override
        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node, context.getContext().getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getContext().getScope()).build();
            List fields = (List)analyzer.analyze(node.getSubquery(), subqueryScope).getRelationType().getAllFields().stream().map(field -> {
                if (field.getName().isPresent()) {
                    return RowType.field((String)field.getName().get(), (Type)field.getType());
                }
                return RowType.field((Type)field.getType());
            }).collect(ImmutableList.toImmutableList());
            ExpressionAnalyzer.this.setExpressionType(node.getSubquery(), (Type)RowType.from((List)fields));
            ExpressionAnalyzer.this.existsSubqueries.add(NodeRef.of(node));
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ExpressionAnalyzer.this.quantifiedComparisons.add(NodeRef.of(node));
            Type declaredValueType = this.process((Node)node.getValue(), context);
            Type comparisonType = this.analyzePredicateWithSubquery(node, declaredValueType, (SubqueryExpression)node.getSubquery(), context);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw new SemanticException(String.format("Type [%s] must be orderable in order to be used in quantified comparison", comparisonType));
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw new SemanticException(String.format("Type [%s] must be comparable in order to be used in quantified comparison", comparisonType));
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", new Object[]{node.getOperator()}));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField field = this.baseScope.getField(node.getFieldIndex());
            return this.handleResolvedField(node, field, context);
        }

        @Override
        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(String.format("not yet implemented: %s", node.getClass().getName()));
        }

        @Override
        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(String.format("not yet implemented: %s", node.getClass().getName()));
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            Type type;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                type = ExpressionAnalyzer.this.metadata.getOperatorReturnType(operatorType, (List<? extends Type>)argumentTypes.build());
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(e.getMessage());
            }
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals(expectedType)) {
                throw new SemanticException(String.format("%s must evaluate to a %s (actual: %s)", message, expectedType, actualType));
            }
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Node node, String message, Expression first, Expression second) {
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if (!firstType.equals(secondType)) {
                throw new SemanticException(String.format("%s: %s vs %s", message, firstType, secondType));
            }
            return firstType;
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, String description, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            LinkedHashMultimap typeExpressions = LinkedHashMultimap.create();
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                typeExpressions.put((Object)type, NodeRef.of(expression));
            }
            Set types = typeExpressions.keySet();
            for (Type type : types) {
                if (superType == UnknownType.UNKNOWN) {
                    superType = type;
                    continue;
                }
                if (TableMetadataImpl.isTwoTypeComparable(Arrays.asList(superType, type))) continue;
                throw new SemanticException(String.format("%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", description, superType, type, typeExpressions.keySet()));
            }
            return superType;
        }
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Set<String> labels;
        private final CorrelationSupport correlationSupport;

        private Context(Scope scope, List<Type> functionInputTypes, Set<String> labels, CorrelationSupport correlationSupport) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.labels = labels;
            this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
        }

        public static Context notInLambda(Scope scope, CorrelationSupport correlationSupport) {
            return new Context(scope, null, null, correlationSupport);
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), this.labels, this.correlationSupport);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, this.labels, this.correlationSupport);
        }

        public static Context patternRecognition(Scope scope, Set<String> labels) {
            return new Context(scope, null, Objects.requireNonNull(labels, "labels is null"), CorrelationSupport.DISALLOWED);
        }

        public Context patternRecognition(Set<String> labels) {
            return new Context(this.scope, this.functionInputTypes, Objects.requireNonNull(labels, "labels is null"), CorrelationSupport.DISALLOWED);
        }

        public Context notExpectingLabels() {
            return new Context(this.scope, this.functionInputTypes, null, this.correlationSupport);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public CorrelationSupport getCorrelationSupport() {
            return this.correlationSupport;
        }
    }

    public static class LabelPrefixedReference {
        private final String label;
        private final Optional<Identifier> column;

        public LabelPrefixedReference(String label, Identifier column) {
            this(label, Optional.of(Objects.requireNonNull(column, "column is null")));
        }

        public LabelPrefixedReference(String label) {
            this(label, Optional.empty());
        }

        private LabelPrefixedReference(String label, Optional<Identifier> column) {
            this.label = Objects.requireNonNull(label, "label is null");
            this.column = Objects.requireNonNull(column, "column is null");
        }

        public String getLabel() {
            return this.label;
        }

        public Optional<Identifier> getColumn() {
            return this.column;
        }
    }
}

