/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.SimplePlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryTransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;

public class SubPlanTypeExtractor {
    private SubPlanTypeExtractor() {
    }

    public static TypeProvider extractor(PlanNode root, TypeProvider allTypes) {
        TypeProvider typeProvider = new TypeProvider(allTypes.getTreeModelTypeMap(), allTypes.getTemplatedInfo());
        root.accept(new Visitor(typeProvider, allTypes), null);
        return typeProvider;
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final TypeProvider typeProvider;
        private final TypeProvider allTypes;

        public Visitor(TypeProvider typeProvider, TypeProvider allTypes) {
            this.typeProvider = typeProvider;
            this.allTypes = allTypes;
        }

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            node.getOutputColumnNames().forEach(name -> this.typeProvider.setTreeModelType((String)name, this.allTypes.getTreeModelType((String)name)));
            for (PlanNode source : node.getChildren()) {
                source.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitSeriesAggregationScan(SeriesAggregationScanNode node, Void context) {
            String sourcePath = node.getSeriesPath().getFullPath();
            this.typeProvider.setTreeModelType(sourcePath, this.allTypes.getTreeModelType(sourcePath));
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, Void context) {
            if (this.typeProvider.getTemplatedInfo() != null) {
                return null;
            }
            AlignedPath alignedPath = node.getAlignedPath();
            for (int i = 0; i < alignedPath.getColumnNum(); ++i) {
                String sourcePath = alignedPath.getPathWithMeasurement(i).getFullPath();
                this.typeProvider.setTreeModelType(sourcePath, this.allTypes.getTreeModelType(sourcePath));
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getAggregationDescriptorList().stream());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitSlidingWindowAggregation(SlidingWindowAggregationNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getAggregationDescriptorList().stream());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitGroupByLevel(GroupByLevelNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getGroupByLevelDescriptors().stream());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitGroupByTag(GroupByTagNode node, Void context) {
            node.getTagValuesToAggregationDescriptors().values().forEach(v -> this.updateTypeProviderByAggregationDescriptor(v.stream().filter(Objects::nonNull)));
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitLastQueryScan(LastQueryScanNode node, Void context) {
            return null;
        }

        @Override
        public Void visitAlignedLastQueryScan(AlignedLastQueryScanNode node, Void context) {
            return null;
        }

        @Override
        public Void visitLastQuery(LastQueryNode node, Void context) {
            if (node.isContainsLastTransformNode()) {
                return this.visitPlan((PlanNode)node, context);
            }
            return null;
        }

        @Override
        public Void visitLastQueryMerge(LastQueryMergeNode node, Void context) {
            if (node.isContainsLastTransformNode()) {
                return this.visitPlan((PlanNode)node, context);
            }
            return null;
        }

        @Override
        public Void visitLastQueryCollect(LastQueryCollectNode node, Void context) {
            if (node.isContainsLastTransformNode()) {
                return this.visitPlan((PlanNode)node, context);
            }
            return null;
        }

        @Override
        public Void visitLastQueryTransform(LastQueryTransformNode node, Void context) {
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitSingleDeviceView(SingleDeviceViewNode node, Void context) {
            if (this.typeProvider.getTemplatedInfo() != null) {
                return null;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            if (this.typeProvider.getTemplatedInfo() != null) {
                return null;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            if (this.typeProvider.getTemplatedInfo() != null) {
                return null;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        private void updateTypeProviderByAggregationDescriptor(Stream<? extends AggregationDescriptor> aggregationDescriptorList) {
            aggregationDescriptorList.flatMap(aggregationDescriptor -> aggregationDescriptor.getInputExpressions().stream()).forEach(expression -> {
                String expressionStr = expression.getExpressionString();
                this.typeProvider.setTreeModelType(expressionStr, this.allTypes.getTreeModelType(expressionStr));
            });
        }
    }
}

