/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class TableMaxMinByBaseAccumulator
implements TableAccumulator {
    protected final TSDataType xDataType;
    protected final TSDataType yDataType;
    private final TsPrimitiveType yExtremeValue;
    private final TsPrimitiveType xResult;
    private boolean xNull = true;
    private boolean initResult;
    public static final String UNSUPPORTED_TYPE_MESSAGE = "Unsupported data type in MaxBy/MinBy: %s";

    protected TableMaxMinByBaseAccumulator(TSDataType xDataType, TSDataType yDataType) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        this.xResult = TsPrimitiveType.getByType((TSDataType)xDataType);
        this.yExtremeValue = TsPrimitiveType.getByType((TSDataType)yDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 2 ? 1 : 0) != 0, (Object)"Length of input Column[] for MaxBy/MinBy should be 2");
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments, mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments, mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments, mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments, mask);
                return;
            }
            case STRING: 
            case TEXT: 
            case BLOB: {
                this.addBinaryInput(arguments, mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments, mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.yDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of max_by/min_by should be BinaryColumn");
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            this.updateFromBytesIntermediateInput(bytes);
        }
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of Max_By/Min_By should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        columnBuilder.writeBinary(new Binary(this.serialize()));
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        this.writeX(columnBuilder);
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.xNull = true;
        this.xResult.reset();
        this.yExtremeValue.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    private void addIntInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateIntResult(column[1].getInt(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateIntResult(column[1].getInt(position), column[0], position);
            }
        }
    }

    private void updateIntResult(int yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getInt())) {
            this.initResult = true;
            this.yExtremeValue.setInt(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addLongInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateLongResult(column[1].getLong(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateLongResult(column[1].getLong(position), column[0], position);
            }
        }
    }

    private void updateLongResult(long yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getLong())) {
            this.initResult = true;
            this.yExtremeValue.setLong(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addFloatInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateFloatResult(column[1].getFloat(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateFloatResult(column[1].getFloat(position), column[0], position);
            }
        }
    }

    private void updateFloatResult(float yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getFloat())) {
            this.initResult = true;
            this.yExtremeValue.setFloat(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addDoubleInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateDoubleResult(column[1].getDouble(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateDoubleResult(column[1].getDouble(position), column[0], position);
            }
        }
    }

    private void updateDoubleResult(double yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getDouble())) {
            this.initResult = true;
            this.yExtremeValue.setDouble(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addBinaryInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateBinaryResult(column[1].getBinary(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateBinaryResult(column[1].getBinary(position), column[0], position);
            }
        }
    }

    private void updateBinaryResult(Binary yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getBinary())) {
            this.initResult = true;
            this.yExtremeValue.setBinary(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addBooleanInput(Column[] column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column[1].isNull(i)) continue;
                this.updateBooleanResult(column[1].getBoolean(i), column[0], i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column[1].isNull(position)) continue;
                this.updateBooleanResult(column[1].getBoolean(position), column[0], position);
            }
        }
    }

    private void updateBooleanResult(boolean yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getBoolean())) {
            this.initResult = true;
            this.yExtremeValue.setBoolean(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void writeX(ColumnBuilder columnBuilder) {
        if (this.xNull) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.xResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.xResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xResult.getDouble());
                break;
            }
            case STRING: 
            case TEXT: 
            case BLOB: {
                columnBuilder.writeBinary(this.xResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
            }
        }
    }

    private void updateX(Column xColumn, int xIndex) {
        if (xColumn.isNull(xIndex)) {
            this.xNull = true;
        } else {
            this.xNull = false;
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    this.xResult.setInt(xColumn.getInt(xIndex));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.xResult.setLong(xColumn.getLong(xIndex));
                    break;
                }
                case FLOAT: {
                    this.xResult.setFloat(xColumn.getFloat(xIndex));
                    break;
                }
                case DOUBLE: {
                    this.xResult.setDouble(xColumn.getDouble(xIndex));
                    break;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    this.xResult.setBinary(xColumn.getBinary(xIndex));
                    break;
                }
                case BOOLEAN: {
                    this.xResult.setBoolean(xColumn.getBoolean(xIndex));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
                }
            }
        }
    }

    private byte[] serialize() {
        byte[] valueBytes;
        int yLength = Utils.calcTypeSize(this.yDataType, this.yExtremeValue);
        if (this.xNull) {
            valueBytes = new byte[yLength + 1];
            Utils.serializeValue(this.yDataType, this.yExtremeValue, valueBytes, 0);
            BytesUtils.boolToBytes((boolean)true, (byte[])valueBytes, (int)yLength);
        } else {
            valueBytes = new byte[yLength + 1 + Utils.calcTypeSize(this.xDataType, this.xResult)];
            int offset = 0;
            Utils.serializeValue(this.yDataType, this.yExtremeValue, valueBytes, offset);
            offset = yLength;
            BytesUtils.boolToBytes((boolean)false, (byte[])valueBytes, (int)offset);
            Utils.serializeValue(this.xDataType, this.xResult, valueBytes, ++offset);
        }
        return valueBytes;
    }

    private void updateFromBytesIntermediateInput(byte[] bytes) {
        int offset = 0;
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.xDataType));
        ColumnBuilder columnBuilder = builder.getValueColumnBuilders()[0];
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                int intMaxVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateIntResult(intMaxVal, columnBuilder.build(), 0);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long longMaxVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateLongResult(longMaxVal, columnBuilder.build(), 0);
                break;
            }
            case FLOAT: {
                float floatMaxVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateFloatResult(floatMaxVal, columnBuilder.build(), 0);
                break;
            }
            case DOUBLE: {
                double doubleMaxVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateDoubleResult(doubleMaxVal, columnBuilder.build(), 0);
                break;
            }
            case STRING: 
            case TEXT: 
            case BLOB: {
                int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                Binary binaryMaxVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                this.readXFromBytesIntermediateInput(bytes, offset += length, columnBuilder);
                this.updateBinaryResult(binaryMaxVal, columnBuilder.build(), 0);
                break;
            }
            case BOOLEAN: {
                boolean booleanMaxVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, ++offset, columnBuilder);
                this.updateBooleanResult(booleanMaxVal, columnBuilder.build(), 0);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.yDataType));
            }
        }
    }

    private void readXFromBytesIntermediateInput(byte[] bytes, int offset, ColumnBuilder columnBuilder) {
        boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
        ++offset;
        if (isXNull) {
            columnBuilder.appendNull();
        } else {
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(BytesUtils.bytesToInt((byte[])bytes, (int)offset));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(BytesUtils.bytesToFloat((byte[])bytes, (int)offset));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(BytesUtils.bytesToDouble((byte[])bytes, (int)offset));
                    break;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    columnBuilder.writeBinary(new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length)));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(BytesUtils.bytesToBool((byte[])bytes, (int)offset));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
                }
            }
        }
    }

    protected abstract boolean check(int var1, int var2);

    protected abstract boolean check(long var1, long var3);

    protected abstract boolean check(float var1, float var2);

    protected abstract boolean check(double var1, double var3);

    protected abstract boolean check(Binary var1, Binary var2);

    protected abstract boolean check(boolean var1, boolean var2);
}

