/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper.CastFunctionHelper;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.function.InterpretedFunctionInvoker;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.LiteralEncoder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.LiteralInterpreter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolResolver;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeCoercion;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.tsfile.read.common.type.Type;

public class IrExpressionInterpreter {
    private final Expression expression;
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final LiteralInterpreter literalInterpreter;
    private final LiteralEncoder literalEncoder;
    private final SessionInfo session;
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final IdentityHashMap<InListExpression, Set<?>> inListCache = new IdentityHashMap();

    public IrExpressionInterpreter(Expression expression, PlannerContext plannerContext, SessionInfo session, Map<NodeRef<Expression>, Type> expressionTypes) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        this.literalEncoder = new LiteralEncoder(plannerContext);
        this.session = Objects.requireNonNull(session, "session is null");
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        Verify.verify((boolean)expressionTypes.containsKey(NodeRef.of(expression)));
        this.functionInvoker = new InterpretedFunctionInvoker();
        this.typeCoercion = new TypeCoercion(plannerContext.getTypeManager()::getType);
    }

    public static Object evaluateConstantExpression(Expression expression, PlannerContext plannerContext, SessionInfo session) {
        Map<NodeRef<Expression>, Type> types = new IrTypeAnalyzer(plannerContext).getTypes(session, TypeProvider.empty(), expression);
        return new IrExpressionInterpreter(expression, plannerContext, session, types).evaluate();
    }

    public Object evaluate() {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, null);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object evaluate(SymbolResolver inputs) {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, inputs);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object optimize(SymbolResolver inputs) {
        return new Visitor(true).processWithExceptionHandling(this.expression, inputs);
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private final boolean optimize;

        private Visitor(boolean optimize) {
            this.optimize = optimize;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process(expression, context);
            }
            catch (SemanticException e) {
                if (this.optimize) {
                    return expression;
                }
                throw e;
            }
        }

        @Override
        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((SymbolResolver)context).getValue(Symbol.from(node));
        }

        @Override
        protected Object visitLiteral(Literal node, Object context) {
            return IrExpressionInterpreter.this.literalInterpreter.evaluate(node, this.type(node));
        }

        @Override
        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value == null;
        }

        @Override
        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value != null;
        }

        @Override
        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type(node));
            return defaultExpression == null ? new SearchedCaseExpression(whenClauses) : new SearchedCaseExpression(whenClauses, defaultExpression);
        }

        @Override
        protected Object visitIfExpression(IfExpression node, Object context) {
            Object condition = this.processWithExceptionHandling(node.getCondition(), context);
            if (condition instanceof Expression) {
                Object trueValue = this.processWithExceptionHandling(node.getTrueValue(), context);
                Object falseValue = this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
                return new IfExpression(this.toExpression(condition, this.type(node.getCondition())), this.toExpression(trueValue, this.type(node.getTrueValue())), falseValue == null ? null : this.toExpression(falseValue, this.type(node.getFalseValue().get())));
            }
            if (Boolean.TRUE.equals(condition)) {
                return this.processWithExceptionHandling(node.getTrueValue(), context);
            }
            return this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
        }

        @Override
        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = this.type(node.getOperand());
            if (operand == null) {
                return this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            }
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, this.type(whenClause.getOperand()))) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type(node));
            return defaultExpression == null ? new SimpleCaseExpression(this.toExpression(operand, this.type(node.getOperand())), whenClauses) : new SimpleCaseExpression(this.toExpression(operand, this.type(node.getOperand())), whenClauses, defaultExpression);
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2)));
        }

        private Type type(Expression expression) {
            Type type = (Type)IrExpressionInterpreter.this.expressionTypes.get(NodeRef.of(expression));
            Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Type not found for expression: %s", (Object)expression);
            return type;
        }

        @Override
        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            List<Object> newOperands = this.processOperands(node, context);
            if (newOperands.isEmpty()) {
                return null;
            }
            if (newOperands.size() == 1) {
                return Iterables.getOnlyElement(newOperands);
            }
            return new CoalesceExpression((List)newOperands.stream().map(value -> this.toExpression(value, this.type(node))).collect(ImmutableList.toImmutableList()));
        }

        private List<Object> processOperands(CoalesceExpression node, Object context) {
            ArrayList<Object> newOperands = new ArrayList<Object>();
            HashSet<Expression> uniqueNewOperands = new HashSet<Expression>();
            for (Expression operand : node.getOperands()) {
                Object value = this.processWithExceptionHandling(operand, context);
                if (value instanceof CoalesceExpression) {
                    for (Expression nestedOperand : ((CoalesceExpression)value).getOperands()) {
                        if (!DeterminismEvaluator.isDeterministic(nestedOperand) || uniqueNewOperands.add(nestedOperand)) {
                            newOperands.add(nestedOperand);
                        }
                        if (!IrUtils.isEffectivelyLiteral(nestedOperand, IrExpressionInterpreter.this.plannerContext, IrExpressionInterpreter.this.session)) continue;
                        Verify.verify((!(nestedOperand instanceof NullLiteral) && (!(nestedOperand instanceof Cast) || !(((Cast)nestedOperand).getExpression() instanceof NullLiteral)) ? 1 : 0) != 0, (String)"Null operand should have been removed by recursive coalesce processing", (Object[])new Object[0]);
                        return newOperands;
                    }
                    continue;
                }
                if (value instanceof Expression) {
                    Expression expr = (Expression)value;
                    Verify.verify((!(value instanceof NullLiteral) ? 1 : 0) != 0, (String)"Null value is expected to be represented as null, not NullLiteral", (Object[])new Object[0]);
                    if (DeterminismEvaluator.isDeterministic(expr) && !uniqueNewOperands.add(expr)) continue;
                    newOperands.add(expr);
                    continue;
                }
                if (value == null) continue;
                newOperands.add(value);
                return newOperands;
            }
            return newOperands;
        }

        @Override
        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            InListExpression valueList = (InListExpression)node.getValueList();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Expression)) {
                Set set = (Set)IrExpressionInterpreter.this.inListCache.get(valueList);
                if (!IrExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                    if (valueList.getValues().stream().allMatch(Literal.class::isInstance)) {
                        if (valueList.getValues().stream().noneMatch(NullLiteral.class::isInstance)) {
                            set = valueList.getValues().stream().map(expr -> this.processWithExceptionHandling((Expression)expr, context)).collect(Collectors.toSet());
                        }
                    }
                    IrExpressionInterpreter.this.inListCache.put(valueList, set);
                }
                if (set != null) {
                    return set.contains(value);
                }
            }
            boolean hasUnresolvedValue = value instanceof Expression;
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Type> types = new ArrayList<Type>(valueList.getValues().size());
            for (Expression expr2 : valueList.getValues()) {
                if (value instanceof Expression && expr2 instanceof Literal) {
                    values.add(expr2);
                    types.add(this.type(expr2));
                    continue;
                }
                Object inValue = this.process(expr2, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(this.type(expr2));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                Boolean result = value.equals(inValue);
                if (result == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !result.booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = this.type(node.getValue());
                List<Expression> expressionValues = this.toExpressions(values, types);
                List simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter(DeterminismEvaluator::isDeterministic).distinct(), expressionValues.stream().filter(expr -> !DeterminismEvaluator.isDeterministic(expr))).collect(ImmutableList.toImmutableList());
                if (simplifiedExpressionValues.size() == 1) {
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, this.toExpression(value, type), (Expression)simplifiedExpressionValues.get(0));
                }
                return new InPredicate(this.toExpression(value, type), new InListExpression(simplifiedExpressionValues));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        @Override
        protected Object visitArithmeticUnary(ArithmeticUnaryExpression node, Object context) {
            Expression valueExpression;
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                valueExpression = this.toExpression(value, this.type(node.getValue()));
                switch (node.getSign()) {
                    case PLUS: {
                        return valueExpression;
                    }
                    case MINUS: {
                        if (valueExpression instanceof ArithmeticUnaryExpression && ((ArithmeticUnaryExpression)valueExpression).getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS)) {
                            return ((ArithmeticUnaryExpression)valueExpression).getValue();
                        }
                        return new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, valueExpression);
                    }
                }
            }
            if (node.getSign() == ArithmeticUnaryExpression.Sign.PLUS) {
                return value;
            }
            try {
                valueExpression = this.toExpression(value, this.type(node.getValue()));
                if (valueExpression instanceof ArithmeticUnaryExpression && ((ArithmeticUnaryExpression)valueExpression).getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS)) {
                    return ((ArithmeticUnaryExpression)valueExpression).getValue();
                }
                return new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, valueExpression);
            }
            catch (Throwable throwable) {
                Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
        }

        @Override
        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.processWithExceptionHandling(node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
            }
            return new ArithmeticBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
        }

        @Override
        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Operator operator = node.getOperator();
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                return this.processIsDistinctFrom(context, left, right);
            }
            if (node.getOperator() == ComparisonExpression.Operator.NOT_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result == null) {
                    return null;
                }
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return (Boolean)result == false;
            }
            if (node.getOperator() == ComparisonExpression.Operator.GREATER_THAN || node.getOperator() == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return result;
            }
            return this.processComparisonExpression(context, operator, left, right);
        }

        private Object processIsDistinctFrom(Object context, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (left == null && right instanceof Expression) {
                return new IsNotNullPredicate((Expression)right);
            }
            if (right == null && left instanceof Expression) {
                return new IsNotNullPredicate((Expression)left);
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return this.invokeOperator(OperatorType.valueOf(ComparisonExpression.Operator.IS_DISTINCT_FROM.name()), this.types(leftExpression, rightExpression), Arrays.asList(left, right));
        }

        private Object processComparisonExpression(Object context, ComparisonExpression.Operator operator, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (right == null) {
                return null;
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(operator, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return new ComparisonExpression(operator, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
        }

        private ComparisonExpression flipComparison(ComparisonExpression comparisonExpression) {
            switch (comparisonExpression.getOperator()) {
                case EQUAL: {
                    return new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                }
                case NOT_EQUAL: {
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                }
                case LESS_THAN: {
                    return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                }
                case LESS_THAN_OR_EQUAL: {
                    return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                }
                case GREATER_THAN: {
                    return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                }
                case GREATER_THAN_OR_EQUAL: {
                    return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)comparisonExpression.getOperator()));
        }

        @Override
        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.processWithExceptionHandling(node.getMin(), context);
            Object max = this.processWithExceptionHandling(node.getMax(), context);
            if (value instanceof Expression || min instanceof Expression || max instanceof Expression) {
                return new BetweenPredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(min, this.type(node.getMin())), this.toExpression(max, this.type(node.getMax())));
            }
            return new BetweenPredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(min, this.type(node.getMin())), this.toExpression(max, this.type(node.getMax())));
        }

        @Override
        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(this.toExpression(value, this.type(node.getValue())));
            }
            return (Boolean)value == false;
        }

        @Override
        protected Object visitLogicalExpression(LogicalExpression node, Object context) {
            ArrayList<Object> terms = new ArrayList<Object>();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Expression term : node.getTerms()) {
                Object processed = this.processWithExceptionHandling(term, context);
                switch (node.getOperator()) {
                    case AND: {
                        if (Boolean.FALSE.equals(processed)) {
                            return false;
                        }
                        if (Boolean.TRUE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                        break;
                    }
                    case OR: {
                        if (Boolean.TRUE.equals(processed)) {
                            return true;
                        }
                        if (Boolean.FALSE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                    }
                }
            }
            if (terms.isEmpty()) {
                switch (node.getOperator()) {
                    case AND: {
                        return true;
                    }
                    case OR: {
                        return false;
                    }
                }
            }
            if (terms.size() == 1) {
                return terms.get(0);
            }
            if (terms.stream().allMatch(Objects::isNull)) {
                return null;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (int i = 0; i < terms.size(); ++i) {
                expressions.add((Object)this.toExpression(terms.get(i), (Type)types.get(i)));
            }
            return new LogicalExpression(node.getOperator(), (List<Expression>)expressions.build());
        }

        @Override
        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals(BooleanLiteral.TRUE_LITERAL);
        }

        @Override
        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expr : node.getArguments()) {
                Object value = this.processWithExceptionHandling(expr, context);
                Type type = this.type(expr);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            if (this.optimize && this.hasUnresolvedValue(argumentValues)) {
                Verify.verify((!node.isDistinct() ? 1 : 0) != 0, (String)"distinct not supported", (Object[])new Object[0]);
                return new FunctionCall(node.getName(), node.isDistinct(), this.toExpressions(argumentValues, argumentTypes));
            }
            return new FunctionCall(node.getName(), node.isDistinct(), this.toExpressions(argumentValues, argumentTypes));
        }

        @Override
        public Object visitCast(Cast node, Object context) {
            Object value = this.processWithExceptionHandling(node.getExpression(), context);
            Type targetType = IrExpressionInterpreter.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            Type sourceType = this.type(node.getExpression());
            if (value instanceof Expression) {
                if (targetType.equals(sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe());
            }
            if (value == null) {
                return null;
            }
            try {
                return CastFunctionHelper.cast(value, sourceType, targetType, IrExpressionInterpreter.this.session);
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        protected Object visitExpression(Expression node, Object context) {
            throw new SemanticException("not yet implemented: " + node.getClass().getName());
        }

        private List<Type> types(Expression ... expressions) {
            return (List)Stream.of(expressions).map(NodeRef::of).map(IrExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private List<Type> types(List<Expression> expressions) {
            return (List)expressions.stream().map(NodeRef::of).map(IrExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(Predicates.instanceOf(Expression.class));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            return IrExpressionInterpreter.this.functionInvoker.invoke(operatorType, IrExpressionInterpreter.this.session, argumentTypes, argumentValues);
        }

        private Expression toExpression(Object base, Type type) {
            return IrExpressionInterpreter.this.literalEncoder.toExpression(base, type);
        }

        private List<Expression> toExpressions(List<Object> values, List<Type> types) {
            return IrExpressionInterpreter.this.literalEncoder.toExpressions(values, types);
        }
    }
}

