/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletInsertNodeReqV2
extends PipeTransferTabletInsertNodeReq {
    protected transient String dataBaseName;

    private PipeTransferTabletInsertNodeReqV2() {
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    @Override
    public InsertBaseStatement constructStatement() {
        List<InsertRowStatement> rowStatements;
        if (!(this.insertNode instanceof InsertRowNode || this.insertNode instanceof InsertTabletNode || this.insertNode instanceof InsertRowsNode)) {
            throw new UnsupportedOperationException(String.format("Unknown InsertNode type %s when constructing statement from insert node.", this.insertNode));
        }
        InsertBaseStatement statement = (InsertBaseStatement)IoTDBDataNodeReceiver.PLAN_TO_STATEMENT_VISITOR.process(this.insertNode, null);
        if (Objects.isNull(this.dataBaseName)) {
            return statement;
        }
        statement.setWriteToTable(true);
        if (statement instanceof InsertRowsStatement && (rowStatements = ((InsertRowsStatement)statement).getInsertRowStatementList()) != null && !rowStatements.isEmpty()) {
            for (InsertRowStatement insertRowStatement : rowStatements) {
                insertRowStatement.setWriteToTable(true);
                insertRowStatement.setDatabaseName(this.dataBaseName);
            }
        }
        statement.setDatabaseName(this.dataBaseName);
        return statement;
    }

    public static PipeTransferTabletInsertNodeReqV2 toTabletInsertNodeReq(InsertNode insertNode, String dataBaseName) {
        PipeTransferTabletInsertNodeReqV2 req = new PipeTransferTabletInsertNodeReqV2();
        req.insertNode = insertNode;
        req.dataBaseName = dataBaseName;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_INSERT_NODE_V2.getType();
        return req;
    }

    public static PipeTransferTabletInsertNodeReqV2 toTPipeTransferReq(InsertNode insertNode, String dataBaseName) {
        PipeTransferTabletInsertNodeReqV2 req = new PipeTransferTabletInsertNodeReqV2();
        req.insertNode = insertNode;
        req.dataBaseName = dataBaseName;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_INSERT_NODE_V2.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            insertNode.serialize(outputStream);
            ReadWriteIOUtils.write((String)req.dataBaseName, (OutputStream)outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return req;
    }

    public static PipeTransferTabletInsertNodeReqV2 fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletInsertNodeReqV2 insertNodeReq = new PipeTransferTabletInsertNodeReqV2();
        insertNodeReq.insertNode = (InsertNode)PlanFragment.deserializeHelper(transferReq.body, null);
        insertNodeReq.dataBaseName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        insertNodeReq.version = transferReq.version;
        insertNodeReq.type = transferReq.type;
        insertNodeReq.body = transferReq.body;
        return insertNodeReq;
    }

    public static byte[] toTPipeTransferBytes(InsertNode insertNode, String dataBaseName) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_INSERT_NODE_V2.getType(), (OutputStream)outputStream);
                insertNode.serialize(outputStream);
                ReadWriteIOUtils.write((String)dataBaseName, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PipeTransferTabletInsertNodeReqV2 that = (PipeTransferTabletInsertNodeReqV2)((Object)obj);
        return Objects.equals(this.dataBaseName, that.dataBaseName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataBaseName);
    }
}

