/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public abstract class AbstractInnerCompactionWriter
extends AbstractCompactionWriter {
    protected CompactionTsFileWriter fileWriter;
    protected boolean isEmptyFile;
    protected TsFileResource targetResource;
    protected long targetPageSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    protected long targetPagePointNum = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();

    protected AbstractInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        boolean enableMemoryControl = IoTDBDescriptor.getInstance().getConfig().isEnableMemControl();
        this.targetResource = targetFileResource;
        this.fileWriter = new CompactionTsFileWriter(targetFileResource.getTsFile(), enableMemoryControl, sizeForFileWriter, this.targetResource.isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);
        this.isEmptyFile = true;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        CompactionUtils.updateResource(this.targetResource, this.fileWriter, this.deviceId);
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
    }

    @Override
    public void write(TimeValuePair timeValuePair, int subTaskId) throws IOException {
        this.checkPreviousTimestamp(timeValuePair.getTimestamp(), subTaskId);
        this.writeDataPoint(timeValuePair.getTimestamp(), timeValuePair.getValue(), this.chunkWriters[subTaskId]);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        this.isEmptyFile = false;
        this.lastTime[subTaskId] = timeValuePair.getTimestamp();
    }

    @Override
    public abstract void write(TsBlock var1, int var2) throws IOException;

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.targetResource.forceMarkDeleted();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public void checkAndMayFlushChunkMetadata() throws IOException {
        this.fileWriter.checkMetadataSizeAndMayFlush();
    }

    @Override
    public long getWriterSize() throws IOException {
        return this.fileWriter.getPos();
    }
}

