/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;

public class CompactionChunkReader {
    private final ChunkHeader chunkHeader;
    private final ByteBuffer chunkDataBuffer;
    private final IUnCompressor unCompressor;
    private final Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private final List<TimeRange> deleteIntervalList;

    public CompactionChunkReader(Chunk chunk) {
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.unCompressor = IUnCompressor.getUnCompressor((CompressionType)this.chunkHeader.getCompressionType());
        this.deleteIntervalList = chunk.getDeleteIntervalList();
    }

    public ByteBuffer readPageDataWithoutUncompressing(PageHeader pageHeader) throws IOException {
        return ChunkReader.readCompressedPageData((PageHeader)pageHeader, (ByteBuffer)this.chunkDataBuffer);
    }

    public TsBlock readPageData(PageHeader pageHeader, ByteBuffer compressedPageData) throws IOException {
        ByteBuffer pageData = ChunkReader.uncompressPageData((PageHeader)pageHeader, (IUnCompressor)this.unCompressor, (ByteBuffer)compressedPageData);
        TSDataType dataType = this.chunkHeader.getDataType();
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)dataType);
        PageReader pageReader = new PageReader(pageHeader, pageData, dataType, valueDecoder, this.timeDecoder, null);
        pageReader.setDeleteIntervalList(this.deleteIntervalList);
        return pageReader.getAllSatisfiedData();
    }
}

