/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.SeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.NonAlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class NonAlignedSeriesCompactionExecutor
extends SeriesCompactionExecutor {
    private boolean hasStartMeasurement = false;
    private CompressionType seriesCompressionType = null;
    private TSEncoding seriesTSEncoding = null;
    private Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap;
    private final List<TsFileResource> sortResources;

    public NonAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, String deviceId, int subTaskId, FastCompactionTaskSummary summary) {
        super(compactionWriter, readerCacheMap, modificationCacheMap, deviceId, false, subTaskId, summary);
        this.sortResources = sortedSourceFiles;
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactFiles();
        if (this.hasStartMeasurement) {
            this.compactionWriter.endMeasurement(this.subTaskId);
        }
    }

    public void setNewMeasurement(Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap) {
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.sortResources.forEach(x -> this.fileList.add(new FileElement((TsFileResource)x)));
        this.hasStartMeasurement = false;
    }

    @Override
    protected void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException {
        while (!this.fileList.isEmpty()) {
            List<FileElement> overlappedFiles = this.findOverlapFiles((FileElement)this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(overlappedFiles);
            this.compactChunks();
        }
    }

    @Override
    void deserializeFileIntoChunkMetadataQueue(List<FileElement> fileElements) throws IOException, IllegalPathException {
        for (FileElement fileElement : fileElements) {
            TsFileResource resource = fileElement.resource;
            Pair<Long, Long> timeseriesMetadataOffset = this.timeseriesMetadataOffsetMap.get(resource);
            if (timeseriesMetadataOffset == null) {
                this.removeFile(fileElement);
                continue;
            }
            List iChunkMetadataList = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesMetadataOffset.left).longValue(), ((Long)timeseriesMetadataOffset.right).longValue());
            if (!iChunkMetadataList.isEmpty()) {
                ModificationUtils.modifyChunkMetaData(iChunkMetadataList, this.getModificationsFromCache(resource, CompactionPathUtils.getPath(this.deviceId, ((IChunkMetadata)iChunkMetadataList.get(0)).getMeasurementUid())));
                if (iChunkMetadataList.isEmpty()) {
                    this.removeFile(fileElement);
                }
            }
            for (int i = 0; i < iChunkMetadataList.size(); ++i) {
                IChunkMetadata chunkMetadata = (IChunkMetadata)iChunkMetadataList.get(i);
                this.chunkMetadataQueue.add(new ChunkMetadataElement(chunkMetadata, resource.getVersion(), i == iChunkMetadataList.size() - 1, fileElement));
            }
        }
    }

    @Override
    void deserializeChunkIntoPageQueue(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.DESERIALIZE_CHUNK);
        Chunk chunk = chunkMetadataElement.chunk;
        CompactionChunkReader chunkReader = new CompactionChunkReader(chunk);
        ByteBuffer chunkDataBuffer = chunk.getData();
        ChunkHeader chunkHeader = chunk.getHeader();
        while (chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            ByteBuffer compressedPageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
            boolean isLastPage = chunkDataBuffer.remaining() <= 0;
            this.pageQueue.add(new NonAlignedPageElement(pageHeader, compressedPageData, chunkReader, chunkMetadataElement, isLastPage, chunkMetadataElement.priority));
        }
        chunkMetadataElement.clearChunks();
    }

    @Override
    void readChunk(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.READ_IN);
        chunkMetadataElement.chunk = ((TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource)).readMemChunk((ChunkMetadata)chunkMetadataElement.chunkMetadata);
        if (!this.hasStartMeasurement) {
            ChunkHeader header = chunkMetadataElement.chunk.getHeader();
            MeasurementSchema schema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
            this.compactionWriter.startMeasurement(Collections.singletonList(schema), this.subTaskId);
            this.hasStartMeasurement = true;
            this.seriesCompressionType = header.getCompressionType();
            this.seriesTSEncoding = header.getEncodingType();
            chunkMetadataElement.needForceDecoding = false;
        } else {
            ChunkHeader header = chunkMetadataElement.chunk.getHeader();
            chunkMetadataElement.needForceDecoding = header.getCompressionType() != this.seriesCompressionType || header.getEncodingType() != this.seriesTSEncoding;
        }
    }

    @Override
    protected ModifiedStatus isPageModified(PageElement pageElement) {
        long startTime = pageElement.getStartTime();
        long endTime = pageElement.getEndTime();
        return this.checkIsModified(startTime, endTime, pageElement.getChunkMetadataElement().chunkMetadata.getDeleteIntervalList());
    }
}

